/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2006-09-28
 * Description : a widget to display a GPS web map locator.
 *
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright 2008 by Gerhard Kulzer <gerhard at kulzer dot net>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// KDE includes.

#include <kdebug.h>
#include <tdehtmlview.h>
#include <kurl.h>

// Local includes.

#include "gpsmapwidget.h"
#include "gpsmapwidget.moc"

namespace KIPIGPSSyncPlugin
{

class GPSMapWidgetPrivate
{

public:

    GPSMapWidgetPrivate()
    {
        gpsLocalorUrl = TQString("http://digikam3rdparty.free.fr/gpslocator/getlonlatalt.php");
    }

    TQString gpsLocalorUrl;
    TQString latitude;
    TQString longitude;
    TQString altitude;
    TQString zoomLevel;
    TQString mapType;
    TQString fileName;
};

GPSMapWidget::GPSMapWidget(TQWidget* parent)
            : TDEHTMLPart(parent)
{
    d = new GPSMapWidgetPrivate;

    setJScriptEnabled(true);
    setDNDEnabled(false);
    setEditable(false);

    view()->setVScrollBarMode(TQScrollView::AlwaysOff);
    view()->setHScrollBarMode(TQScrollView::AlwaysOff);
    view()->setMinimumSize(480, 360);
}

GPSMapWidget::~GPSMapWidget()
{
    delete d;
}

void GPSMapWidget::setFileName(const TQString& fileName)
{
    d->fileName = fileName;
}

TQString GPSMapWidget::fileName()
{
    return d->fileName;
}

void GPSMapWidget::setGPSPosition(const TQString& lat, const TQString& lon)
{
    d->latitude  = lat;
    d->longitude = lon;
}

void GPSMapWidget::setMapType(const TQString& mapType)
{
    d->mapType = mapType;
}

TQString GPSMapWidget::mapType()
{
    return d->mapType;
}

void GPSMapWidget::setZoomLevel(int zoomLevel)
{
    d->zoomLevel = TQString::number(zoomLevel);
}

int GPSMapWidget::GPSMapWidget::zoomLevel()
{
    return d->zoomLevel.toInt();
}

void GPSMapWidget::extractGPSPositionfromStatusbar(const TQString& txt)
{
    TQString status = txt;
    status.remove(0, 5);
    status.truncate(status.length()-1);
    d->latitude  = status.section(",", 0, 0);
    d->longitude = status.section(",", 1, 1);
    d->altitude = status.section(",", 2, 2);
    d->longitude.remove(0, 5);
    d->altitude.remove(0, 5);
    emit signalNewGPSLocationFromMap(d->latitude, d->longitude, d->altitude);
}

void GPSMapWidget::tdehtmlMouseMoveEvent(tdehtml::MouseMoveEvent *e)
{
    TQString status = jsStatusBarText();

    // If a new point to the map have been moved, the Status
    // string is like : "(lat:25.5894748, lon:47.6897455478, alt:211)"
    if (status.startsWith(TQString("(lat:")))
        extractGPSPositionfromStatusbar(status);

    TDEHTMLPart::tdehtmlMouseMoveEvent(e);
}

void GPSMapWidget::tdehtmlMouseReleaseEvent(tdehtml::MouseReleaseEvent *e)
{
    TQString status = jsStatusBarText();

    // If a new point to the map have been moved, the Status
    // string is like : "(lat:25.5894748, lon:47.6897455478, alt:211)"
    if (status.startsWith(TQString("(lat:")))
        extractGPSPositionfromStatusbar(status);

    // If a new map zoom level have been selected, the Status
    // string is like : "newZoomLevel:5"
    if (status.startsWith(TQString("newZoomLevel:")))
    {
        status.remove(0, 13);
        d->zoomLevel = status;
    }

    // If a new map type have been selected, the Status
    // string is like : "newMapType:G_SATELLITE_TYPE"
    if (status.startsWith(TQString("newMapType:")))
    {
        status.remove(0, 11);
        d->mapType = status;
    }

    TDEHTMLPart::tdehtmlMouseReleaseEvent(e);
}

void GPSMapWidget::resized()
{
    TQString url = d->gpsLocalorUrl;
    url.append("?latitude=");
    url.append(d->latitude);
    url.append("&longitude=");
    url.append(d->longitude);
    url.append("&altitude=");
    url.append(d->altitude);
    url.append("&width=");
    url.append(TQString::number(view()->width()));
    url.append("&height=");
    url.append(TQString::number(view()->height()));
    url.append("&zoom=");
    url.append(d->zoomLevel);
    url.append("&maptype=");
    url.append(d->mapType);
    url.append("&filename=");
    url.append(d->fileName);
    openURL(KURL(url));
    kdDebug( 51001 ) << url << endl;
}

}  // namespace KIPIGPSSyncPlugin
