/***************************************************************************
    begin                : Tue Aug 12 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
                           (C) 2006 by Michel Ludwig
    email                : Jeroen.Wijnhout@kdemail.net
                           michel.ludwig@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KILEPROJECTVIEW_H
#define KILEPROJECTVIEW_H

#include <ktrader.h>
#include <tdelistview.h>

#include "kileproject.h"

class KURL;
class TDEPopupMenu;
class TDEToggleAction;
namespace KileDocument {
    class Info;
}
class KileInfo;

namespace KileType {enum ProjectView { Project=0, ProjectItem, ProjectExtra, File, Folder};}

class KileProjectViewItem : public TQObject, public TDEListViewItem
{
	TQ_OBJECT
  

public:
	KileProjectViewItem (TQListView *parent, KileProjectItem *item, bool ar = false) : TDEListViewItem(parent, item->url().fileName()), m_folder(-1), m_projectItem(item) { setArchiveState(ar);}
	KileProjectViewItem (TQListView *parent, TQListViewItem *after, KileProjectItem *item, bool ar = false) : TDEListViewItem(parent, after, item->url().fileName()), m_folder(-1), m_projectItem(item) { setArchiveState(ar);}
	KileProjectViewItem (TQListViewItem *parent, KileProjectItem *item, bool ar = false) : TDEListViewItem(parent, item->url().fileName()), m_folder(-1), m_projectItem(item) { setArchiveState(ar);}

	//use this to create folders
	KileProjectViewItem (TQListViewItem *parent, const TQString & name) : TDEListViewItem(parent, name), m_folder(-1), m_projectItem(0L) {}

	//use this to create non-project files
	KileProjectViewItem (TQListView *parent, const TQString & name) : TDEListViewItem(parent, name), m_folder(-1), m_projectItem(0L) {}
	
	KileProjectViewItem (TQListView *parent, const KileProject *project) : TDEListViewItem(parent, project->name()), m_folder(-1), m_projectItem(0L) {}
	

	~KileProjectViewItem() {KILE_DEBUG() << "DELETING PROJVIEWITEM " << m_url.fileName() << endl;}

	KileProjectItem* projectItem() { return m_projectItem; }

	KileProjectViewItem* parent() { return dynamic_cast<KileProjectViewItem*>(TDEListViewItem::parent()); }
	KileProjectViewItem* firstChild() { return dynamic_cast<KileProjectViewItem*>(TDEListViewItem::firstChild()); }
	KileProjectViewItem* nextSibling() { return dynamic_cast<KileProjectViewItem*>(TDEListViewItem::nextSibling()); }

	void setInfo(KileDocument::Info *docinfo) { m_docinfo = docinfo;}
	KileDocument::Info * getInfo() { return m_docinfo;}

	void setType(KileType::ProjectView type) {m_type = type;}
	KileType::ProjectView type() const { return m_type;}

	int compare(TQListViewItem * i, int col, bool ascending) const;

	void setURL(const KURL & url) { m_url=url;}
	const KURL& url() { return m_url;}

	void setArchiveState(bool ar) { setText(1,ar ? "*" : "");}

	void setFolder(int folder) { m_folder = folder; }
	int folder() { return m_folder; }

public slots:
	/**
	 * @warning Does nothing if "url" is empty !
	 **/ 
	void urlChanged(const KURL & url);
	void nameChanged(const TQString & name);
	void isrootChanged(bool isroot);

private slots:
	/**
	 * Dummy slot, simply forwarding to urlChanged(const KURL& url).
	 **/
	void slotURLChanged(KileDocument::Info*, const KURL & url);


private:
	KURL	m_url;
	KileType::ProjectView	m_type;
	KileDocument::Info	*m_docinfo;
	int   m_folder;
	KileProjectItem *m_projectItem;
};

class KileProjectView : public TDEListView
{
	TQ_OBJECT
  

public:
	KileProjectView(TQWidget *parent, KileInfo *ki);

signals:
	void fileSelected(const KileProjectItem *);
	void fileSelected(const KURL &);
	void saveURL(const KURL&);
	void closeURL(const KURL&);
	void projectOptions(const KURL &);
	void projectArchive(const KURL &);
	void addFiles(const KURL &);
	void openAllFiles(const KURL &);
	void toggleArchive(KileProjectItem *);
	void closeProject(const KURL &);
	void addToProject(const KURL &);
	void removeFromProject(const KileProjectItem *);
	void buildProjectTree(const KURL &);

public slots:
	void slotClicked(TQListViewItem * item = 0);

	void slotFile(int id);
	void slotProjectItem(int id);
	void slotProject(int id);

	void slotRun(int id);

	void refreshProjectTree(const KileProject *);
	void add(const KURL & url);
	void add(const KileProject *project);
	void remove(const KURL & url);
	void remove(const KileProject *project);
	void removeItem(const KileProjectItem *, bool);
	KileProjectViewItem* add(KileProjectItem *item, KileProjectViewItem * projvi  = 0);

public:
	void addTree(KileProjectItem *item, KileProjectViewItem * projvi );

	KileProjectViewItem* projectViewItemFor(const KURL &);
	KileProjectViewItem* itemFor(const KURL &);
	KileProjectViewItem* parentFor(const KileProjectItem *projitem, KileProjectViewItem *projvi);

protected:
	virtual bool acceptDrag(TQDropEvent *e) const;

private slots:
	void popup(TDEListView *, TQListViewItem *, const TQPoint &);

private:
	void makeTheConnection(KileProjectViewItem *);
	KileProjectViewItem* folder(const KileProjectItem *item, KileProjectViewItem *);

private:
	KileInfo					*m_ki;
	TDEPopupMenu		*m_popup;
	uint						m_nProjects;
	TDEToggleAction		*m_toggle;

	TDETrader::OfferList m_offerList;
};

#endif
