/***************************************************************************
 *   Copyright (C) 2005 by Joachim Eibl                                    *
 *   joachim.eibl at gmx.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef SMALLDIALOGS_H
#define SMALLDIALOGS_H

#include <tqdialog.h>
#include "diff.h"

class OptionDialog;
class TQComboBox;
class TQCheckBox;
class TQLineEdit;
class TQLabel;

class OpenDialog : public TQDialog
{
   TQ_OBJECT
  
public:
   OpenDialog(
      TQWidget* pParent, const TQString& n1, const TQString& n2, const TQString& n3,
      bool bMerge, const TQString& outputName, const char* slotConfigure, OptionDialog* pOptions  );

   TQComboBox* m_pLineA;
   TQComboBox* m_pLineB;
   TQComboBox* m_pLineC;
   TQComboBox* m_pLineOut;

   TQCheckBox* m_pMerge;
   virtual void accept();
   virtual bool eventFilter(TQObject* o, TQEvent* e);
private:
   OptionDialog* m_pOptions;
   void selectURL( TQComboBox* pLine, bool bDir, int i, bool bSave );
   bool m_bInputFileNameChanged;
private slots:
   void selectFileA();
   void selectFileB();
   void selectFileC();
   void selectDirA();
   void selectDirB();
   void selectDirC();
   void selectOutputName();
   void selectOutputDir();
   void internalSlot(int);
   void inputFilenameChanged();
   void slotSwapCopyNames(int);
signals:
   void internalSignal(bool);
};

class FindDialog : public TQDialog
{
   TQ_OBJECT
  
public:
   FindDialog(TQWidget* pParent);

signals:
   void findNext();

public:
   TQLineEdit* m_pSearchString;
   TQCheckBox* m_pSearchInA;
   TQCheckBox* m_pSearchInB;
   TQCheckBox* m_pSearchInC;
   TQCheckBox* m_pSearchInOutput;
   TQCheckBox* m_pCaseSensitive;

   int currentLine;
   int currentPos;
   int currentWindow;
};


class RegExpTester : public TQDialog
{
   TQ_OBJECT
  
private:
   TQLineEdit* m_pAutoMergeRegExpEdit;
   TQLineEdit* m_pAutoMergeMatchResult;
   TQLineEdit* m_pAutoMergeExampleEdit;
   TQLineEdit* m_pHistoryStartRegExpEdit;
   TQLineEdit* m_pHistoryStartMatchResult;
   TQLineEdit* m_pHistoryStartExampleEdit;
   TQLineEdit* m_pHistoryEntryStartRegExpEdit;
   TQLineEdit* m_pHistorySortKeyOrderEdit;
   TQLineEdit* m_pHistoryEntryStartExampleEdit;
   TQLineEdit* m_pHistoryEntryStartMatchResult;
   TQLineEdit* m_pHistorySortKeyResult;
   OptionDialog* m_pOptionDialog;
public:
   RegExpTester( TQWidget* pParent, const TQString& autoMergeRegExpToolTip, const TQString& historyStartRegExpToolTip, 
                                   const TQString& historyEntryStartRegExpToolTip, const TQString& historySortKeyOrderToolTip  );
   void init( const TQString& autoMergeRegExp, const TQString& historyStartRegExp, const TQString& historyEntryStartRegExp, const TQString sortKeyOrder );
   TQString autoMergeRegExp();
   TQString historyStartRegExp();
   TQString historyEntryStartRegExp();
   TQString historySortKeyOrder();
public slots:
   void slotRecalc();
};

#endif
