/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PLUGIN_H_
#define PLUGIN_H_

extern "C" {
#include <lber.h>
#include <ldap.h>

#ifdef HAVE_SLAPI_PLUGIN_H
#include <slapi-plugin.h>
#else
#include "slapi-plugin.h"
#endif
}

#define PLUGIN_NAME "slapi-acl-manager"

void log_msg (int level, const char* msg, ...);
void log_plugin (const char* msg, ...);

#define return_val_if_fail(expr, ret) \
	do { if (expr) { } else { \
		log_plugin ("*** %s *** check failed: '%s' at %s:%d", PLUGIN_NAME, #expr, __PRETTY_FUNCTION__, __LINE__); \
		return (ret); \
	} } while (0)
#define return_if_fail(expr) \
	do { if (expr) { } else { \
		log_plugin ("*** %s *** check failed: '%s' at %s:%d", PLUGIN_NAME, #expr, __PRETTY_FUNCTION__, __LINE__); \
		return; \
	} } while (0)

#endif /*PLUGIN_H_*/
