/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxspinxmenu.h"

KbfxSpinxMenuWidget::KbfxSpinxMenuWidget ( TQWidget * parent, const char *name,
        WFlags fl ) :
		TQWidget ( parent, "MenuWidget",
		          fl |  TQt::WStyle_Customize | TQt::WStyle_NoBorder | TQt::WStyle_StaysOnTop )
{
	m_parent = parent;
	TQString _name=name;
	init();

}

void
KbfxSpinxMenuWidget::reinit()
{
	emit refresh();
	init();

}

void
KbfxSpinxMenuWidget::init()
{
		createMask ();

	TQWidget *main = new TQWidget ( this );

	m_kbfxSpinxTop = new KbfxSpinxTop ( main );
	m_toolBarBot = new KbfxSpinxToolBar ( main );
	m_toolBarBot->setMinimumHeight ( ConfigInit ().m_botBar_h );
	m_toolBarBot->setMaximumHeight ( ConfigInit ().m_botBar_h );
	m_kbfxSpinxTop->setMaximumHeight ( ConfigInit ().m_topBar_h );
	m_kbfxSpinxTop->setMinimumHeight ( ConfigInit ().m_topBar_h );

	TQWidget *middle = new TQWidget ( main );

	middle->setPalette ( TQPalette ( TQColor ( 24, 233, 233 ) ) );

//	m_middleFrame = new TQHBoxLayout(middle);

	m_canvasView = new KbfxPlasmaCanvasView ( this );
	m_indexView = new KbfxPlasmaIndexView ( this );
	m_indexLeftView = new KbfxPlasmaIndexView ( this );

	/* Search Box */
	m_searchTag = new KbfxPixmapLabel ( this, "Search:" );
	TQToolTip::add( m_searchTag, tr2i18n( "Double click to clear..." ) );
	m_searchTag->normalize ();
	m_searchTag->move ( ConfigInit ().m_searchBox_x,
	                    ConfigInit ().m_searchBox_y );

	TQPixmap m_searchPixmap = ( *KbfxPlasmaPixmapProvider::pixmap ( "find" ) );

	m_searchTag->setPixmap ( m_searchPixmap );

	m_searchTag->resize ( m_searchPixmap.width (), ConfigInit ().m_searchBox_h );

	m_search = new TQLineEdit ( this, "Search BOX" );
	TQToolTip::add( m_search, tr2i18n( "Type here to search..." ) );
	m_search->setFrameShape ( TQFrame::NoFrame );
	m_search->setFocusPolicy ( TQWidget::StrongFocus );
	m_search->move ( ConfigInit ().m_searchBox_x + m_searchTag->width (),
	                 ConfigInit ().m_searchBox_y );
	m_search->resize ( ConfigInit ().m_searchBox_w - m_searchTag->width (),
	                   ConfigInit ().m_searchBox_h );

	connect (m_searchTag, TQ_SIGNAL (mouseDoubleClicked ( const ButtonState & )), this,
			 TQ_SLOT (search_clear ( const ButtonState & )));

	int frameHeight = ConfigInit().m_listBox_h;

            if (frameHeight <=  (this->height () - ( m_kbfxSpinxTop->height () + m_toolBarBot->height ()) ) ) {
                frameHeight =  (this->height () - ( m_kbfxSpinxTop->height () +
                                                        m_toolBarBot->height ()) );
            }

//	m_middleFrame->addWidget(middleleft);
	m_canvasView->setMaximumHeight ( ConfigInit().m_itemView_h );
	m_canvasView->setMinimumHeight ( ConfigInit().m_itemView_h );
	m_canvasView->setMaximumWidth ( ConfigInit ().m_itemView_w );
	m_canvasView->setMinimumWidth ( ConfigInit ().m_itemView_w );
	m_appCanvas = new TQCanvas ( m_canvasView->width (), m_canvasView->height () );
	m_canvasView->setKbfxCanvas ( m_appCanvas );
	m_appCanvas->setDoubleBuffering ( true );

	m_indexView->setMaximumHeight ( frameHeight );
	m_indexView->setMinimumHeight ( frameHeight );
	m_indexView->setMaximumWidth ( ConfigInit ().m_listBox_w );
	m_indexView->setMinimumWidth ( ConfigInit ().m_listBox_w );
	m_indexCanvas = new TQCanvas ( m_indexView->width (), m_indexView->height () );
	m_indexView->setKbfxCanvas ( m_indexCanvas );
	m_indexCanvas->setDoubleBuffering ( true );
	m_indexView->setView ( m_canvasView );

	m_indexLeftView->setMaximumHeight ( frameHeight );
	m_indexLeftView->setMinimumHeight ( frameHeight );
	m_indexLeftView->setMaximumWidth ( ConfigInit ().m_listBox_w );
	m_indexLeftView->setMinimumWidth ( ConfigInit ().m_listBox_w );
	m_indexLeftCanvas =
	    new TQCanvas ( m_indexLeftView->width (), m_indexLeftView->height () );
	m_indexLeftView->setKbfxCanvas ( m_indexLeftCanvas );
	m_indexLeftCanvas->setDoubleBuffering ( true );
	m_indexLeftView->setView ( m_canvasView );


	m_canvasView->move ( ConfigInit ().m_itemView_x, ConfigInit ().m_itemView_y );
	m_indexView->move ( ConfigInit ().m_listBox_x, ConfigInit ().m_listBox_y );
	m_indexLeftView->move ( ConfigInit ().m_listBox_w + ConfigInit ().m_itemView_w,
	                        ConfigInit ().m_listBox_y );

	m_fixedFrame = new TQVBoxLayout ( main );
	m_fixedFrame->setResizeMode ( TQLayout::Minimum );
	m_fixedFrame->addWidget ( m_kbfxSpinxTop );
	m_fixedFrame->addWidget ( middle );
	m_fixedFrame->addWidget ( m_toolBarBot );

	m_loadedListLeft = " ";
	m_loadedListRight = " ";

	main->resize ( this->size () );

	loadHistory ();

	connect ( m_indexView, TQ_SIGNAL ( loadRequest ( KbfxSignal ) ), m_canvasView,
	          TQ_SLOT ( handleLoadRequest ( KbfxSignal ) ) );

	connect ( m_indexLeftView, TQ_SIGNAL ( loadRequest ( KbfxSignal ) ), m_canvasView,
	          TQ_SLOT ( handleLoadRequest ( KbfxSignal ) ) );

	connect ( m_canvasView, TQ_SIGNAL ( clicked () ), this, TQ_SLOT ( hideMenu () ) );

	connect ( m_search, TQ_SIGNAL ( textChanged ( const TQString & ) ), m_canvasView,
	          TQ_SLOT ( search ( const TQString & ) ) );

	connect ( m_indexView,
	          TQ_SIGNAL ( pluginRequest ( TQString, KbfxPlasmaCanvasView * ) ),
	          m_indexView, TQ_SLOT ( loadPlugin ( TQString, KbfxPlasmaCanvasView * ) ) );

	connect ( m_indexLeftView,
	          TQ_SIGNAL ( pluginRequest ( TQString, KbfxPlasmaCanvasView * ) ),
	          m_indexLeftView,
	          TQ_SLOT ( loadPlugin ( TQString, KbfxPlasmaCanvasView * ) ) );

	connect ( m_indexView,
	          TQ_SIGNAL ( clearSelected() ),
	          m_indexLeftView, TQ_SLOT ( clearSelection() ) );

	connect ( m_indexLeftView,
	          TQ_SIGNAL ( clearSelected() ),
	          m_indexView,
	          TQ_SLOT ( clearSelection() ) );

	connect (this,TQ_SIGNAL(refresh()),m_canvasView,TQ_SLOT(reload()));
	connect (this,TQ_SIGNAL(runItem()),m_canvasView,TQ_SLOT(execFirst()));

	KbfxSpinxToolButton *logout = new KbfxSpinxToolButton ( m_toolBarBot );
	KbfxSpinxToolButton *lock = new KbfxSpinxToolButton ( m_toolBarBot );

	lock ->setPixmaps ( ( *KbfxPlasmaPixmapProvider::pixmap ( "lock" ) ),
						( *KbfxPlasmaPixmapProvider::pixmap ( "lockhover" ) ) );

	logout ->setPixmaps ( ( *KbfxPlasmaPixmapProvider::pixmap ( "logout" ) ),
						  ( *KbfxPlasmaPixmapProvider::pixmap ( "logouthover" ) ) );

	KbfxDataSource *logoutSrc = new KbfxDataSource ();
	logoutSrc->setCommand ( "dcop kdesktop KDesktopIface logout" );
	logoutSrc->setName ( "Logout" );

	KbfxDataSource *lockSrc = new KbfxDataSource ();
	lockSrc->setCommand ( "dcop kdesktop KScreensaverIface lock" );
	lockSrc->setName ( "logout" );

	logout->setDataSource ( logoutSrc );
	lock ->setDataSource ( lockSrc );

	delete logoutSrc;
	delete lockSrc;
	m_toolBarBot->addButton ( logout );
	m_toolBarBot->addButton ( lock );

	connect ( logout,TQ_SIGNAL ( clicked() ),this , TQ_SLOT ( hideMenu() ) );
	connect ( lock ,TQ_SIGNAL ( clicked() ),this , TQ_SLOT ( hideMenu() ) );
}


KbfxSpinxMenuWidget::~KbfxSpinxMenuWidget ()
{
}

void
KbfxSpinxMenuWidget::search_clear ( const ButtonState & _btn )
{
	if ( _btn == TQt::LeftButton )
	{
		/* Clear the search box */
		m_search->clear();
		/* Clear the search canvas */
		m_canvasView->clearAll ();
	}
}

/*
void
KbfxSpinxMenuWidget::changeHeight (int het)
{

}
*/

void
KbfxSpinxMenuWidget::createMask ()
{
	TQPixmap maskpng = ( *KbfxPlasmaPixmapProvider::pixmap ( "mask" ) );
	TQImage rawimg = maskpng.convertToImage ();

	rawimg =
	    rawimg.smoothScale ( ConfigInit ().m_userMenuWidth,
	                   ConfigInit ().m_userMenuHeight,
	                   TQImage::ScaleFree );

	maskpng.convertFromImage ( rawimg );

	setMinimumWidth ( maskpng.width () );
	setMinimumHeight ( maskpng.height () );
//	setMaximumWidth ( maskpng.width () );
//	setMaximumHeight ( maskpng.height () );
	if ( !maskpng.mask () )
		if ( rawimg.hasAlphaBuffer () )
		{
			TQBitmap bm;
			bm.convertFromImage(rawimg.createAlphaMask ());
			maskpng.setMask ( bm );
		}
		else
		{
			TQBitmap bm;
			bm.convertFromImage(rawimg.createHeuristicMask ());
		//	maskpng.setMask ( bm );
		}

	if ( maskpng.mask () && m_parent )
		m_parent->setMask ( *maskpng.mask () );
}

void
KbfxSpinxMenuWidget::resizeContent ()
{}

void
KbfxSpinxMenuWidget::loadHistory ()
{
	TQStringList::Iterator it;
	for ( it = ConfigInit ().m_pluginsLeft.begin ();
	        it != ConfigInit ().m_pluginsLeft.end (); ++it )
	{
            if ( (*it) != NULL)
		this->loadPluginLeft ( ( *it ) );
	}
	for ( it = ConfigInit ().m_pluginsRight.begin ();
	        it != ConfigInit ().m_pluginsRight.end (); ++it )
	{
            if ( (*it) != NULL)
		this->loadPluginRight ( ( *it ) );
	}
}

void
KbfxSpinxMenuWidget::enterPressed ()
{
	kdDebug() << "TODO: Implement Enter Presed" << endl;
}

/*
void
KbfxSpinxMenuWidget::propergateMove (TQMouseEvent * me)
{
}
*/

void
KbfxSpinxMenuWidget::hideMenu ()
{
	emit nowHidden ();
	m_parent->hide ();
}

/*
void
KbfxSpinxMenuWidget::mouseMoveEvent (TQMouseEvent * me)
{
//      m_listBox->setFocus();
}
*/

void
KbfxSpinxMenuWidget::loadPluginLeft ( TQString name )
{
    if (name == NULL) {
            return;
    }
	if ( m_loadedListLeft.contains ( name ) <= 0 )
	{
		m_loader = new KbfxPlasmaPluginLoader ();
		m_stack_R = m_loader->getView ( name );

		if ( m_stack_R == NULL )
			return;

		m_canvasView->addStack ( m_stack_R, name );
		m_indexView->loadList ( m_stack_R );
		delete m_loader;
		m_loadedListLeft += name;
		return;
	}
	else
	{
		kdDebug() << "Plugin already loaded" << endl;
		return;
	}
}

void
KbfxSpinxMenuWidget::loadPluginRight ( TQString name )
{
if ( m_loadedListRight.contains ( name ) <= 0 )
	{
		m_loader = new KbfxPlasmaPluginLoader ();
		m_stack_R = m_loader->getView ( name );

		if ( m_stack_R == NULL )
			return;

		m_canvasView->addStack ( m_stack_R, name );
		m_indexLeftView->loadList ( m_stack_R );
		delete m_loader;
		m_loadedListRight += name;
		return;
	}
	else
	{
		kdDebug() << "Plugin already loaded" << endl;
		return;
	}
}

/*
void
KbfxSpinxMenuWidget::focusInEvent (TQFocusEvent * te)
{
	kdDebug() << "TODO: Handle Focus Event" << endl;
}
*/

void
KbfxSpinxMenuWidget::keyPressEvent ( TQKeyEvent * e )
{
	if ( e->key () == TQt::Key_Backspace )
	{
		m_search->backspace ();
		return;
	}

	else if ( e->key () == TQt::Key_Escape )
	{
		hideMenu ();
		return;
	}

	else if ( e->key() == TQt::Key_Return )
    {
        hideMenu ();
        m_canvasView->setFocus ();
        KRun::runCommand ( m_search->text ());
        return;
    }

	else if ( e->key () == TQt::Key_Up )
	{
		m_search->setFocus ();
		return;
	}

	else if ( e->key () == TQt::Key_Down )
	{
		m_canvasView->setFocus ();
		return;
	}

	else if (  e->key () == TQt::Key_Control
			|| e->key () == TQt::Key_Alt
			|| e->key () == TQt::Key_Pause
			|| e->key () == TQt::Key_Print
			|| e->key () == TQt::Key_SysReq
			|| e->key () == TQt::Key_Meta
			|| e->key () == TQt::Key_CapsLock
			|| e->key () == TQt::Key_NumLock
			|| e->key () == TQt::Key_ScrollLock
			|| e->key () == TQt::Key_F1
			|| e->key () == TQt::Key_F2
			|| e->key () == TQt::Key_F3
			|| e->key () == TQt::Key_F4
			|| e->key () == TQt::Key_F5
			|| e->key () == TQt::Key_F6
			|| e->key () == TQt::Key_F7
			|| e->key () == TQt::Key_F8
			|| e->key () == TQt::Key_F9
			|| e->key () == TQt::Key_F10
			|| e->key () == TQt::Key_F11
			|| e->key () == TQt::Key_F12
			|| e->key () == TQt::Key_F13
			|| e->key () == TQt::Key_F14
			|| e->key () == TQt::Key_F15
			|| e->key () == TQt::Key_F16
			|| e->key () == TQt::Key_F17
			|| e->key () == TQt::Key_F18
			|| e->key () == TQt::Key_F19
			|| e->key () == TQt::Key_F20
			|| e->key () == TQt::Key_Super_L
			|| e->key () == TQt::Key_Super_R
			|| e->key () == TQt::Key_Menu
			|| e->key () == TQt::Key_Hyper_L
			|| e->key () == TQt::Key_Hyper_R
			|| e->key () == TQt::Key_Help
			|| e->key () == TQt::Key_Back
			|| e->key () == TQt::Key_Forward
			|| e->key () == TQt::Key_Stop
			|| e->key () == TQt::Key_Refresh
			|| e->key () == TQt::Key_VolumeDown
			|| e->key () == TQt::Key_VolumeMute
			|| e->key () == TQt::Key_VolumeUp
			|| e->key () == TQt::Key_BassBoost
			|| e->key () == TQt::Key_BassUp
			|| e->key () == TQt::Key_BassDown
			|| e->key () == TQt::Key_TrebleUp
			|| e->key () == TQt::Key_TrebleDown
			|| e->key () == TQt::Key_MediaPlay
			|| e->key () == TQt::Key_MediaStop
			|| e->key () == TQt::Key_MediaPrev
			|| e->key () == TQt::Key_MediaNext
			|| e->key () == TQt::Key_MediaRecord
			|| e->key () == TQt::Key_HomePage
			|| e->key () == TQt::Key_Favorites
			|| e->key () == TQt::Key_Search
			|| e->key () == TQt::Key_Standby
			|| e->key () == TQt::Key_OpenUrl
			|| e->key () == TQt::Key_LaunchMail
			|| e->key () == TQt::Key_LaunchMedia
			)
	{
		hideMenu ();
		e->ignore();
		return;
	}

/*
    else if ( e->key() == TQt::Key_Alt  )
	{
		hideMenu ();
		m_canvasView->setFocus ();
		emit runItem ();
		return;
	}


	else if ( e->key () == TQt::Key_Tab )
	{
//		m_listBox->setFocus ();
		return;
	}

	else if ( e->key () >= TQt::Key_0 && e->key () <= TQt::Key_9 )
	{
		printf ( "%d \n", e->key () );
		emit runItemAt ( e->key () );
		return;
	}

	else if ( e->key () == TQt::Key_Left )
	{
		m_canvasView->setFocus ();
		m_canvasView->emulatedKeyPress ( e );
		return;
	}
*/

	m_search->show ();
	m_search->setText ( m_search->text () + e->text () );
	e->ignore();
}

#include "kbfxspinxmenu.moc"
