/***************************************************************************
 *   Copyright (C) 2005 by Bastian Holst                                   *
 *   bastianholst@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tdeglobal.h>
#include <kiconloader.h>
#include <tqpixmap.h>
#include <tqstring.h>
#include <tqcstring.h>
#include <tqdatastream.h>
#include <tdeapplication.h>
#include <dcopclient.h>
#include <tdelocale.h>

#include <katapultitem.h>

#include "actionplaysong.h"
#include "song.h"

TQPixmap ActionPlaySong::icon(int size) const
{
	return TDEGlobal::iconLoader()->loadIcon("amarok", TDEIcon::NoGroup, size);
}

TQString ActionPlaySong::text() const
{
	return i18n("Play Song");
}

bool ActionPlaySong::accepts(const KatapultItem *item) const
{
	return strcmp(item->className(), "Song") == 0;
}
		
void ActionPlaySong::execute(const KatapultItem *item) const
{
	const Song *song = (const Song *) item;
	TQByteArray buffer;
	TQDataStream stream(buffer, IO_WriteOnly);
	stream << song->url();
	tdeApp->dcopClient()->send("amarok", "playlist", "playMedia(KURL)", buffer);
}
