//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "k9mp4dlg.h"
#include <tqlabel.h>
#include <kprogress.h>
#include <tqpainter.h>
#include <tdestandarddirs.h>
#include <tqlayout.h>
#include "k9drawimage.h"


k9MP4Dlg::k9MP4Dlg(TQWidget* parent, const char* name)
: MP4Dlg(parent,name, true)
{
  m_wimage=new k9DrawImage(image,0);
  TQGridLayout *l=new TQGridLayout(image,1,1);
  l->addWidget(m_wimage,0,0);
  m_timer.start();
}

k9MP4Dlg::~k9MP4Dlg()
{
}

/*$SPECIALIZATION$*/

void k9MP4Dlg::Cancel() {
   //TQDialog::accept();
   emit sigCancel();
}

void k9MP4Dlg::setTitleLabel(TQString _titleLabel) {
    lblTitle->setText(_titleLabel);
}


void k9MP4Dlg::setfps(TQString _fps) {
    lblfps->setText(_fps);
}

void k9MP4Dlg::setremain(TQString _remain) {
    if (m_timer.elapsed() >=1000) {
        lblRemain->setText(_remain);
        m_timer.restart();
    }
}

void k9MP4Dlg::setProgress(int _progress) {
    pbProgress->setProgress(_progress);

}

void k9MP4Dlg::setbitrate(TQString _bitrate) {
    lblbitrate->setText(_bitrate);
}

void k9MP4Dlg::setsize( TQString _size) {
    lblsize->setText(_size);
}


void k9MP4Dlg::setImage(TQString _fileName) {
    m_wimage->setImage(_fileName);
}



#include "k9mp4dlg.moc"

