/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
// TQt includes
#include <tqtimer.h>

// KDE includes
#include <kdebug.h>
#include <tdeversion.h>
#include <tdefilefiltercombo.h>
#include <kimageio.h>
#include <tdelocale.h>
#include <kurlcombobox.h>

// Our includes
#include "imagesavedialog.moc"
namespace Gwenview {


static int findFormatInFilterList(const TQStringList& filters, const TQString& format) {
	int pos=0;
	for(TQStringList::const_iterator it=filters.begin(); it!=filters.end(); ++it,++pos) {
		TQStringList list=TQStringList::split("|",*it);
		if ( list[1].startsWith(format) ) return pos;
	}
	return -1;
}


ImageSaveDialog::ImageSaveDialog(KURL& url, const TQCString& imageFormat, TQWidget* parent)
: KFileDialog(":ImageSaveDialog",TQString(),parent,"imagesavedialog",true)
, mURL(url)
, mImageFormat(imageFormat)
{
	setOperationMode(KFileDialog::Saving);

	// FIXME: Ugly code to define the filter combo label.
	KMimeType::List types;
	setFilterMimeType(i18n("Format:"),types,KMimeType::mimeType(""));
	
	TQStringList filters;

	// Create our filter list
	TQStringList mimeTypes=KImageIO::mimeTypes();
	for(TQStringList::const_iterator it=mimeTypes.begin(); it!=mimeTypes.end(); ++it) {
		TQString format=KImageIO::typeForMime(*it);
		
		// Create the pattern part of the filter string
		KMimeType::Ptr mt=KMimeType::mimeType(*it);
		TQStringList patterns;
		for (TQStringList::const_iterator patIt=mt->patterns().begin();patIt!=mt->patterns().end();++patIt) {
			TQString pattern=(*patIt).lower();
			if (!patterns.contains(pattern)) patterns.append(pattern);
		}
		if (patterns.isEmpty()) {
			patterns.append( TQString("*.%1").arg(format.lower()) );
		}
		TQString patternString=patterns.join(" ");

		// Create the filter string
		TQString filter=patternString + "|"
			      + format + " - " + mt->comment()
			      + " (" + patternString + ")";
		
		// Add it to our list
		filters.append(filter);
	}
	
	qHeapSort(filters);
	setFilter(filters.join("\n"));
	
	// Select the default image format
	int pos=findFormatInFilterList(filters,mImageFormat);
	if (pos==-1) {
		pos=findFormatInFilterList(filters,"PNG");
		mImageFormat="PNG";
	}
	
	filterWidget->setCurrentItem(pos);

	// Tweak the filter widget
	filterWidget->setEditable(false);
	
	connect(filterWidget,TQ_SIGNAL(activated(const TQString&)),
		this,TQ_SLOT(updateImageFormat(const TQString&)) );
	
	// Call slotFilterChanged() to get the list filtered by the filter we
	// selected. If we don't use a single shot, it leads to a crash :-/
	TQTimer::singleShot(0,this,TQ_SLOT(slotFilterChanged()));
}


void ImageSaveDialog::accept() {
	KFileDialog::accept();
	mURL=selectedURL();
}


void ImageSaveDialog::updateImageFormat(const TQString& text) {
	TQStringList list=TQStringList::split(" ",text);
	mImageFormat=list[0].local8Bit();
	
	TQString name=locationEdit->currentText();
	TQString suffix=KImageIO::suffix(mImageFormat);
	int dotPos=name.findRev('.');
	if (dotPos>-1) {
		name=name.left(dotPos);
	} 
	name.append('.').append(suffix);
	locationEdit->setCurrentText(name);
}


} // namespace
