//Author: Max Howell <max.howell@methylblue.com>, (C) 2004
//Copyright: See COPYING file that comes with this distribution

#include "fileTree.h"
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tqfile.h>


//static definitions
const uint File::DENOMINATOR[4] = { 1<<0, 1<<10, 1<<20, 1<<30 };
static const char PREFIX[4]   = { 'K', 'M', 'G', 'T' };


TQString
File::fullPath( const Directory *root /*= 0*/ ) const
{
   TQString path;

   if( root == this )
      root = 0; //prevent returning empty string when there is something we could return

   for( const Directory *d = (Directory*)this; d != root && d; d = d->parent() )
      path.prepend( d->name() );

   return path;
}

TQString
File::humanReadableSize( UnitPrefix key /*= mega*/ ) const //FIXME inline
{
   return humanReadableSize( m_size, key );
}

TQString
File::humanReadableSize( uint size, UnitPrefix key /*= mega*/ ) //static
{
   if( size == 0 )
      return "0 B";

   TQString s;
   double prettySize = (double)size / (double)DENOMINATOR[key];
   const TDELocale &locale = *TDEGlobal::locale();

   if( prettySize >= 0.01 )
   {
      //use three significant figures
      if( prettySize < 1 )        s = locale.formatNumber( prettySize, 2 );
      else if( prettySize < 100 ) s = locale.formatNumber( prettySize, 1 );
      else                        s = locale.formatNumber( prettySize, 0 );

      s += ' ';
      s += PREFIX[key];
      s += 'B';
   }

   if( prettySize < 0.1 )
   {
      s += " (";
      s += locale.formatNumber( size / DENOMINATOR[key - 1], 0 );
      s += ' ';
      s += PREFIX[key - 1];
      s += "B)";
   }

   return s;
}
