/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-04-21
 * Description : a menu widget to pick a date.
 *               this widget come from libtdepim.
 *
 * Copyright (C) 2004 Bram Schoenmakers <bramschoenmakers@kde.nl>
 * Copyright (C) 2006 Mikolaj Machowski <mikmach@wp.pl>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqdatetime.h>
#include <tqpopupmenu.h>

// KDE includes.

#include <tdelocale.h>

// Local includes.

#include "kdatepickerpopup.h"
#include "kdatepickerpopup.moc"

namespace Digikam
{

KDatePickerPopup::KDatePickerPopup(int items, const TQDate &date, TQWidget *parent,
                                    const char *name)
                : TQPopupMenu( parent, name )
{
    mItems      = items;
    mDatePicker = new KDatePicker( this );
    mDatePicker->setCloseButton( false );

    connect( mDatePicker, TQ_SIGNAL( dateEntered( TQDate ) ),
               this, TQ_SLOT( slotDateChanged( TQDate ) ) );

    connect( mDatePicker, TQ_SIGNAL( dateSelected( TQDate ) ),
               this, TQ_SLOT( slotDateChanged( TQDate ) ) );

    mDatePicker->setDate( date );
    buildMenu();
}

void KDatePickerPopup::buildMenu()
{
    if ( isVisible() ) return;
    clear();

    if ( mItems & DatePicker ) 
    {
        insertItem( mDatePicker );

        if ( ( mItems & NoDate ) || ( mItems & Words ) )
        insertSeparator();
    }

    if ( mItems & Words ) 
    {
        insertItem( i18n("&Today"),       this, TQ_SLOT( slotToday() ) );
        insertItem( i18n("Y&esterday"),   this, TQ_SLOT( slotYesterday() ) );
        insertItem( i18n("Last &Monday"), this, TQ_SLOT( slotPrevMonday() ) );
        insertItem( i18n("Last &Friday"), this, TQ_SLOT( slotPrevFriday() ) );
        insertItem( i18n("Last &Week"),   this, TQ_SLOT( slotPrevWeek() ) );
        insertItem( i18n("Last M&onth"),  this, TQ_SLOT( slotPrevMonth() ) );

        if ( mItems & NoDate )
        insertSeparator();
    }

    if ( mItems & NoDate )
        insertItem( i18n("No Date"), this, TQ_SLOT( slotNoDate() ) );
}

KDatePicker *KDatePickerPopup::datePicker() const
{
    return mDatePicker;
}

void KDatePickerPopup::setDate( const TQDate &date )
{
    mDatePicker->setDate( date );
}

#if 0
void KDatePickerPopup::setItems( int items )
{
    mItems = items;
    buildMenu();
}
#endif

void KDatePickerPopup::slotDateChanged( TQDate date )
{
    emit dateChanged( date );
    hide();
}

void KDatePickerPopup::slotToday()
{
    emit dateChanged( TQDate::currentDate() );
}

void KDatePickerPopup::slotYesterday()
{
    emit dateChanged( TQDate::currentDate().addDays( -1 ) );
}

void KDatePickerPopup::slotPrevFriday()
{
    TQDate date = TQDate::currentDate();
    int day = date.dayOfWeek();
    if ( day < 6 )
        date = date.addDays( 5 - 7 - day );
    else
        date = date.addDays( 5 - day );

    emit dateChanged( date );
}

void KDatePickerPopup::slotPrevMonday()
{
    TQDate date = TQDate::currentDate();
    emit dateChanged( date.addDays( 1 - date.dayOfWeek() ) );
}

void KDatePickerPopup::slotNoDate()
{
    emit dateChanged( TQDate() );
}

void KDatePickerPopup::slotPrevWeek()
{
    emit dateChanged( TQDate::currentDate().addDays( -7 ) );
}

void KDatePickerPopup::slotPrevMonth()
{
    emit dateChanged( TQDate::currentDate().addMonths( -1 ) );
}

}  // namespace Digikam


