#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


find_package( Ruby )

if( NOT RUBY_FOUND )
   tde_message_fatal( "The Ruby interpreter and Its headers are required but were not found on your system" )
endif()

# In ruby 1.9.x, ruby.h is located in a different location than previous releases.
execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(MAJOR))"
  OUTPUT_VARIABLE RUBY_VERSION_MAJOR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(MINOR))"
  OUTPUT_VARIABLE RUBY_VERSION_MINOR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(archdir))"
  OUTPUT_VARIABLE RUBY_ARCH_DIR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(sitearchdir))"
  OUTPUT_VARIABLE RUBY_SITEARCH_DIR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(sitelibdir))"
  OUTPUT_VARIABLE RUBY_SITE_DIR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(libdir))"
  OUTPUT_VARIABLE RUBY_LIB_DIR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(rubylibdir))"
  OUTPUT_VARIABLE RUBY_RUBYLIB_DIR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(LIBRUBYARG_SHARED))"
  OUTPUT_VARIABLE RUBY_LDFLAGS
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

execute_process(
  COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.key?(%q(rubyhdrdir))"
  OUTPUT_VARIABLE HAVE_RUBYHDR_DIR
  RESULT_VARIABLE _result
  OUTPUT_STRIP_TRAILING_WHITESPACE )

if( HAVE_RUBYHDR_DIR )
  execute_process(
    COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(rubyhdrdir))"
    OUTPUT_VARIABLE RUBY_INCLUDE_DIR
    RESULT_VARIABLE _result
    OUTPUT_STRIP_TRAILING_WHITESPACE )

  execute_process(
    COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.key?(%q(rubyarchhdrdir))"
    OUTPUT_VARIABLE HAVE_RUBYARCHHDR_DIR
    RESULT_VARIABLE _result
    OUTPUT_STRIP_TRAILING_WHITESPACE )

  if( HAVE_RUBYARCHHDR_DIR )
    execute_process(
      COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(rubyarchhdrdir))"
      OUTPUT_VARIABLE RUBY_ARCHINCLUDE_DIR
      RESULT_VARIABLE _result
      OUTPUT_STRIP_TRAILING_WHITESPACE )
  else( )
    execute_process(
      COMMAND ${RUBY_EXECUTABLE} -r rbconfig -e "puts RbConfig::CONFIG.fetch(%q(arch))"
      OUTPUT_VARIABLE RUBY_ARCH
      RESULT_VARIABLE _result
      OUTPUT_STRIP_TRAILING_WHITESPACE )
    set( RUBY_ARCHINCLUDE_DIR "${RUBY_INCLUDE_DIR}/${RUBY_ARCH}" CACHE INTERNAL "" )
  endif( )
  set( RUBY_CFLAGS "-I${RUBY_INCLUDE_DIR} -I${RUBY_ARCHINCLUDE_DIR}" CACHE INTERNAL "" )
else( )
  set( RUBY_INCLUDE_DIR ${RUBY_ARCH_DIR} CACHE INTERNAL "" )
  set( RUBY_CFLAGS "-I${RUBY_INCLUDE_DIR}" CACHE INTERNAL "" )
endif( )

if( RUBY_INCLUDE_DIR AND RUBY_LDFLAGS )
  message( STATUS "    archdir ${RUBY_ARCH_DIR}" )
  message( STATUS "    sitearchdir ${RUBY_SITEARCH_DIR}" )
  message( STATUS "    sitedir ${RUBY_SITE_DIR}" )
  message( STATUS "    rubylibdir ${RUBY_RUBYLIB_DIR}" )
  message( STATUS "    libdir ${RUBY_LIB_DIR}" )
  message( STATUS "    includedir ${RUBY_INCLUDE_DIR}" )
  message( STATUS "    librubyarg ${RUBY_LDFLAGS}" )
  message( STATUS "    cflags ${RUBY_CFLAGS}" )
endif( )

if ( "${RUBY_VERSION_MAJOR}${RUBY_VERSION_MINOR}" VERSION_LESS "19" )
  message( STATUS "    ruby version << 1.9" )
  set ( HAVE_OLD_RUBY 1 CACHE INTERNAL "" )
endif( )
