/***************************************************************************
                               pathmapper.h
                         ------------------------
    begin                : 2004-10-10
    copyright            : (C) 2004 Linus McCabe

 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/


#ifndef PATHMAPPER_H
#define PATHMAPPER_H

#include <tqobject.h>
#include <tqdom.h>
#include <tqstringlist.h>

class KURL;

class PathMapper : public TQObject
{
    TQ_OBJECT
  

  public:
    PathMapper(TQObject *parent = 0, const char *name = 0);
    PathMapper();
    virtual TQString mapLocalPathToServer(const TQString &localpath);
    virtual TQString mapServerPathToLocal(const TQString &serverpath);

    virtual void setLocalBasedir(const TQString &localpath);
    virtual void setServerBasedir(const TQString &serverpath);

    void readConfig();
    
  private:
    TQDomNode pathMapperNode();
    TQString translate(const TQString & path, const TQString & from, const TQString &to);
    void addHistory(const TQString &localpath, const TQString &serverpath, bool saveinproject);
    
    TQString m_localBasedir;
    TQString m_serverBasedir;

    TQStringList m_serverlist;
    TQStringList m_locallist;
};

#endif
