/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef CONNECTIONEDITORIMPL_H
#define  CONNECTIONEDITORIMPL_H

#include "connectioneditor.h"
#include "metadatabase.h"

#include <tqmap.h>

class TQListViewItem;
class FormWindow;

class ConnectionEditor : public ConnectionEditorBase
{
  TQ_OBJECT
  
public:
  ConnectionEditor(TQWidget* parent, TQObject* sender, TQObject* receiver, FormWindow* fw);
  ~ConnectionEditor();

protected slots:
  // Add current pair <signal, slot> to the list
  void connectClicked();
  // Remove current pair <signal, slot> to the list
  void disconnectClicked();
  // Lists all connections defined in current dialog
  void fillConnectionsList();
  // Lists all widgets in sender or receiver combo
  void fillWidgetList(KComboBox* a_combo, const TQStringList& items, const TQString& defaultWidget);
  // Sender widget was changed - update signal list
  void senderChanged(const TQString & s);
  // Receiver widget was changed - update slot list
  void receiverChanged(const TQString & s);
  // Enable/disable 'Connect' button when pair <signal,slot> changes
  void updateConnectButton();
  // Enable/disable 'Disconnect' button when selection changes
  void updateDisconnectButton();
  // Accept and close button
  void okClicked();
  // Cancel and close button
  void cancelClicked();
  
private:
  // Whether given signal should appear in the signal list
  bool isSignalIgnored(const char*) const;
  // Whether given slot should appear in the slot list
  bool isSlotIgnored(const TQMetaData* md);
  // Finds widget by name
  TQObject* objectByName(const TQString& s) const;
  bool hasConnection(const TQString & snder, const TQString & signal,
      const TQString & rcvr, const TQString & slot)  const;
  TQMap <TQListViewItem*, MetaDataBase::Connection> m_connections;
  TQValueList <MetaDataBase::Connection> m_oldConnections;
  TQObject* m_sender;
  TQObject* m_receiver;
  FormWindow* m_formWindow;
};

#endif
