/**********************************************************************
** Copyright (C) 2001 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef TQCOMPLETIONEDIT_H
#define TQCOMPLETIONEDIT_H

#include <tqlineedit.h>
#include <tqstringlist.h>

class TQListBox;
class TQVBox;

class QCompletionEdit : public TQLineEdit
{
    TQ_OBJECT
  
    TQ_PROPERTY( bool autoAdd READ autoAdd WRITE setAutoAdd )
    TQ_PROPERTY( bool caseSensitive READ isCaseSensitive WRITE setCaseSensitive )

public:
    QCompletionEdit( TQWidget *parent = 0, const char *name = 0 );

    bool autoAdd() const;
    TQStringList completionList() const;
    bool eventFilter( TQObject *o, TQEvent *e );
    bool isCaseSensitive() const;

public slots:
    void setCompletionList( const TQStringList &l );
    void setAutoAdd( bool add );
    void clear();
    void addCompletionEntry( const TQString &entry );
    void removeCompletionEntry( const TQString &entry );
    void setCaseSensitive( bool b );

signals:
    void chosen( const TQString &text );

private slots:
    void textDidChange( const TQString &text );

private:
    void placeListBox();
    void updateListBox();

private:
    bool aAdd;
    TQStringList compList;
    TQListBox *listbox;
    TQVBox *popup;
    bool caseSensitive;

};



#endif
