import SCons.Defaults
import SCons.Tool
import SCons.Util
def generate(env):
    SCons.Tool.createStaticLibBuilder(env)
    arcom='$AR $ARFLAGS $TARGET $SOURCES'
    ranlib='ranlib'
    if env.Detect(ranlib):
        arcom=arcom + '\n$RANLIB $RANLIBFLAGS $TARGET'
    env['AR']         ='ar'
    env['ARFLAGS']    =SCons.Util.CLVar('r')
    env['RANLIB']     =ranlib
    env['RANLIBFLAGS']=SCons.Util.CLVar('')
    env['ARCOM']      =arcom
    env['LIBPREFIX']  ='lib'
    env['LIBSUFFIX']  ='.a'
def exists(env):
    return env.Detect('ar')
