#include "tipofday_part.h"

#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqwhatsthis.h>

#include <tdeaboutdata.h>
#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kdevgenericfactory.h>
#include <kdevplugininfo.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <ktextbrowser.h>
#include <ktip.h>

#include "kdevapi.h"
#include "kdevcore.h"

static const KDevPluginInfo pluginData("kdevtipofday");

typedef KDevGenericFactory<TipOfDayPart> TipOfDayFactory;
K_EXPORT_COMPONENT_FACTORY( libkdevtipofday, TipOfDayFactory( pluginData ) )

TipOfDayPart::TipOfDayPart(TQObject *parent, const char *name, const TQStringList &)
  : KDevPlugin(&pluginData, parent, name ? name : "TipOfDayPart")
{
  setInstance(TipOfDayFactory::instance());

  setXMLFile("kdevpart_tipofday.rc");

  TDEAction *action;

  action = new TDEAction(i18n("&Tip of the Day"), "idea", 0,
                       this, TQ_SLOT(showTip()), actionCollection(), "help_tipofday");
  action->setToolTip(i18n("A tip how to use TDevelop"));
  action->setWhatsThis(i18n("<b>Tip of the day</b><p>"
                            "Will display another good tip \n"
                            "contributed by KDevelop users."));

  connect(core(), TQ_SIGNAL(coreInitialized()), this, TQ_SLOT(showOnStart()));
}


TQString TipOfDayPart::getFilename()
{
  TDEConfig * config = TDEApplication::kApplication()->config();
  config->setGroup("Tip of day plugin");
  return config->readEntry("TipsFile", "kdevtipofday/tips");
}

void TipOfDayPart::showTip()
{
  KTipDialog::showTip(getFilename(), true);
}


void TipOfDayPart::showOnStart()
{
  KTipDialog::showTip(getFilename());
}



#include "tipofday_part.moc"
