/***************************************************************************
 *   Copyright (C) 2004 by ian reinhart geiser                             *
 *   geiseri@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef __PACKAGEBASE_H__
#define __PACKAGEBASE_H__

#include <kurl.h>
#include <tqstringlist.h>

class packageBase
{

public:
   packageBase();
   virtual ~packageBase();
   
// Generic accessors and mutators for child classes
   virtual TQString generatePackage( ) = 0 ;
   //virtual bool loadFile(KURL theFile) = 0;
   //virtual bool saveFile(KURL theFile) = 0;

   virtual TQString getAppName();
   virtual TQString getAppVersion();
   virtual TQString getAppRevision();
   virtual TQString getAppGroup();
   virtual TQString getAppPackager();
   virtual TQString getAppURL();
   virtual TQString getAppSummary();
   virtual TQString getAppVendor();
   virtual TQString getAppLicense();
   virtual TQString getAppArch();
   virtual TQString getAppDescription();
   virtual TQString getAppChangelog();
   virtual TQString getAppSource();
   virtual TQStringList getAppFileList();
   
   virtual void setAppName(const TQString&);
   virtual void setAppVersion(const TQString&);
   virtual void setAppRevision(const TQString&);
   virtual void setAppGroup(const TQString&);
   virtual void setAppPackager(const TQString&);
   virtual void setAppURL(const TQString&);
   virtual void setAppSummary(const TQString&);
   virtual void setAppVendor(const TQString&);
   virtual void setAppLicense(const TQString&);
   virtual void setAppArch(const TQString&);
   virtual void setAppDescription(const TQString&);
   virtual void setAppChangelog(const TQString&);
   virtual void setAppFileList(const TQStringList &list);
   
   private:
   	TQString AppName;
	TQString AppVersion;
	TQString AppRevision;
	TQString AppGroup;
	TQString AppPackager;
	TQString AppURL;
	TQString AppSummary;
	TQString AppVendor;
	TQString AppLicense;
	TQString AppArch;
	TQString AppDescription;
	TQString AppChangelog;
	TQString AppSource;
	TQStringList AppFileList;
};

#endif
