#include "fileselector_part.h"

#include <tqwhatsthis.h>
#include <tqpushbutton.h>
#include <tqcheckbox.h>
#include <tqslider.h>
#include <tqvbox.h>

#include <kiconloader.h>
#include <tdelocale.h>
#include <tdeapplication.h>
#include <kstandarddirs.h>
#include <ktextbrowser.h>
#include <tdeconfig.h>
#include <tdefileitem.h>
#include <kdevgenericfactory.h>
#include <tdediroperator.h>
#include <kdialogbase.h>
#include <tdemessagebox.h>

#include <kdevapi.h>
#include <kdevcore.h>
#include <kdevproject.h>
#include <kdevmainwindow.h>
#include <kdevpartcontroller.h>
#include <kdevplugininfo.h>
#include <kdevcreatefile.h>

#include <ktip.h>

#include "fileselector_widget.h"

typedef KDevGenericFactory<FileSelectorPart> FileSelectorFactory;
static const KDevPluginInfo pluginData("kdevfileselector");
K_EXPORT_COMPONENT_FACTORY( libkdevfileselector, FileSelectorFactory( pluginData ) )

FileSelectorPart::FileSelectorPart(TQObject *parent, const char *name, const TQStringList &)
    : KDevPlugin(&pluginData, parent, name ? name : "FileSelectorPart")
{
    setInstance(FileSelectorFactory::instance());

    m_filetree = new KDevFileSelector( this, mainWindow(), partController(), 0, "fileselectorwidget" );

    connect( m_filetree->dirOperator(), TQ_SIGNAL(fileSelected(const KFileItem*)),
	     this, TQ_SLOT(fileSelected(const KFileItem*)));
    connect( core(), TQ_SIGNAL(projectOpened()), this, TQ_SLOT(slotProjectOpened()) );

    connect( core(), TQ_SIGNAL(configWidget(KDialogBase*)), this, TQ_SLOT(slotConfigWidget(KDialogBase*)) );

    m_filetree->setCaption( i18n("File Selector") );
	m_filetree->setIcon( SmallIcon( info()->icon() ) );
    mainWindow()->embedSelectView( m_filetree, i18n("File Selector"), i18n("File selector") );
    TQWhatsThis::add(m_filetree, i18n("<b>File selector</b><p>This file selector lists directory contents and provides some file management functions."));

    m_filetree->readConfig( instance()->config(), "fileselector" );

    m_newFileAction = new TDEAction(i18n("New File..."), CTRL+ALT+SHIFT+Key_N, this, TQ_SLOT(newFile()), this, "new_file");
}

FileSelectorPart::~FileSelectorPart()
{
    if (m_filetree){
	mainWindow()->removeView( m_filetree );
    }

    delete (KDevFileSelector*) m_filetree;
}

void FileSelectorPart::fileSelected( const KFileItem * file )
{
    KURL u(file->url());

    partController()->editDocument( u );
}

void FileSelectorPart::slotProjectOpened()
{
    KURL u;
    u.setPath( project()->projectDirectory() );
    m_filetree->setDir( u );
}

void FileSelectorPart::slotConfigWidget( KDialogBase * dlg )
{
	TQVBox* vbox = dlg->addVBoxPage( i18n("File Selector"), i18n("File Selector"), BarIcon( info()->icon(), TDEIcon::SizeMedium) );
    KFSConfigPage* page = new KFSConfigPage( vbox, 0, m_filetree );
    connect( dlg, TQ_SIGNAL( okClicked( ) ), page, TQ_SLOT( apply( ) ) );
    // ### implement reload
}

void FileSelectorPart::newFile()
{
    KDevCreateFile *creator = extension<KDevCreateFile>("TDevelop/CreateFile");
    if (creator)
    {
        KDevCreateFile::CreatedFile file = creator->createNewFile("",
            m_filetree->dirOperator()->url().path());
        if (file.status == KDevCreateFile::CreatedFile::STATUS_NOTCREATED)
            KMessageBox::error(0, i18n("Cannot create file. Check whether the directory and filename are valid."));
        else if (file.status != KDevCreateFile::CreatedFile::STATUS_CANCELED)
        {
            partController()->editDocument(KURL::fromPathOrURL(
                file.dir + "/" + file.filename));
        }
    }
}

#include "fileselector_part.moc"
