/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef GRAPHTREELABEL_H
#define GRAPHTREELABEL_H

#include "drawparams.h"
#include <tqcanvas.h>

/**
	@author Rajko Albrecht <ral@alwins-world.de>
*/
class GraphTreeLabel : public TQCanvasRectangle,StoredDrawParams
{
public:
    GraphTreeLabel(const TQString&,const TQString&,const TQRect&r,TQCanvas*c);
    virtual ~GraphTreeLabel();

    virtual int rtti()const;
    virtual void drawShape(TQPainter& p);

    void setBgColor(const TQColor&);

    const TQString&nodename()const;
    const TQString&source()const;
    void setSource(const TQString&);
    virtual void setSelected(bool);

protected:
    TQString m_Nodename;
    TQString m_SourceNode;
};

class GraphEdge;

class GraphEdgeArrow:public TQCanvasPolygon
{
public:
    GraphEdgeArrow(GraphEdge*,TQCanvas*);
    GraphEdge*edge();
    virtual void drawShape(TQPainter&);
    virtual int rtti()const;

private:
    GraphEdge*_edge;
};

/* line */
class GraphEdge:public TQCanvasSpline
{
public:
    GraphEdge(TQCanvas*);
    virtual ~GraphEdge();

    virtual void drawShape(TQPainter&);
    TQPointArray areaPoints() const;
    virtual int rtti()const;
};

class GraphMark:public TQCanvasRectangle
{
public:
    GraphMark(GraphTreeLabel*,TQCanvas*);
    virtual ~GraphMark();
    virtual int rtti()const;
    virtual bool hit(const TQPoint&)const;

    virtual void drawShape(TQPainter&);
private:
    static TQPixmap*_p;
};

#endif
