/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2006-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

// own header
#include "cmdlineexportallviewsevent.h"

// qt includes
#include <tqstringlist.h>

// kde includes
#include <tdeapplication.h>
#include <kdebug.h>

// app includes
#include "uml.h"
#include "umlviewimageexportermodel.h"


int CmdLineExportAllViewsEvent::getType() {
    return TQEvent::User + 1;
}

CmdLineExportAllViewsEvent::CmdLineExportAllViewsEvent(const TQString &imageType, const KURL &directory, const bool useFolders)
  : TQCustomEvent(CmdLineExportAllViewsEvent::getType()) {
    m_imageType = imageType;
    m_directory = directory;
    m_useFolders = useFolders;
}

void CmdLineExportAllViewsEvent::exportAllViews() {
    TQStringList errors = UMLViewImageExporterModel().exportAllViews(m_imageType, m_directory, m_useFolders);
    if (!errors.isEmpty()) {
        kError() << "Errors while exporting:" << endl;
        for (TQStringList::Iterator it = errors.begin(); it != errors.end(); ++it) {
            kError() << *it << endl;
        }
    }

    kapp->sendEvent(UMLApp::app(), new TQCloseEvent());
}
