/*
    This file is part of KOrganizer.

    Copyright (c) 1997, 1998, 1999
    Preston Brown (preston.brown@yale.edu)
    Fester Zigterman (F.J.F.ZigtermanRustenburg@student.utwente.nl)
    Ian Dawes (iadawes@globalserve.net)
    Laszlo Boloni (boloni@cs.purdue.edu)

    Copyright (c) 2000-2003 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include "korganizer.h"

#include "komailclient.h"
#include "calendarview.h"
#include "koviewmanager.h"
#include "kodialogmanager.h"
#include "kowindowlist.h"
#include "koprefs.h"
#include "kocore.h"
#include "konewstuff.h"
#include "actionmanager.h"
#include "koglobals.h"
#include "alarmclient.h"
#include "resourceview.h"
#include "korganizerifaceimpl.h"

#include <korganizer/part.h>

#include <libtdepim/statusbarprogresswidget.h>
#include <libtdepim/progressdialog.h>

#include <libkcal/calendarlocal.h>
#include <libkcal/calendarresources.h>
#include <libkcal/resourcecalendar.h>

#include <tdeglobal.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <tdestdaccel.h>
#include <tdefiledialog.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <kedittoolbar.h>
#include <tdetempfile.h>
#include <tdeio/netaccess.h>
#include <tdemessagebox.h>
#include <dcopclient.h>
#include <kprocess.h>
#include <twin.h>
#include <ktip.h>
#include <kstdguiitem.h>
#include <kstatusbar.h>

#include <tqcursor.h>
#include <tqtimer.h>
#include <tqvbox.h>
#include <tqfile.h>
#include <tqlabel.h>
#include <tqlayout.h>

#include <stdlib.h>

using namespace KParts;
#include "korganizer.moc"
using namespace KOrg;

KOrganizer::KOrganizer( const char *name )
  : KParts::MainWindow( 0, name ),
    KOrg::MainWindow()
{
  // Set this to be the group leader for all subdialogs - this means
  // modal subdialogs will only affect this dialog, not the other windows
  setWFlags( getWFlags() | WGroupLeader );

  kdDebug(5850) << "KOrganizer::KOrganizer()" << endl;
  KOCore::self()->addXMLGUIClient( this, this );
//  setMinimumSize(600,400);  // make sure we don't get resized too small...

  mCalendarView = new CalendarView( this, "KOrganizer::CalendarView" );
  setCentralWidget(mCalendarView);

  mActionManager = new ActionManager( this, mCalendarView, this, this, false );
  (void)new KOrganizerIfaceImpl( mActionManager, this, "IfaceImpl" );
}

KOrganizer::~KOrganizer()
{
  delete mActionManager;

  KOCore::self()->removeXMLGUIClient( this );
}

void KOrganizer::init( bool document )
{
  kdDebug(5850) << "KOrganizer::init() "
            << ( document ? "hasDocument" : "resources" ) << endl;

  setHasDocument( document );

  // Create calendar object, which manages all calendar information associated
  // with this calendar view window.
  if ( hasDocument() ) {
    mActionManager->createCalendarLocal();
  } else {
    mActionManager->createCalendarResources();
  }

  mActionManager->init();
  connect( mActionManager, TQ_SIGNAL( actionNew( const KURL & ) ),
           TQ_SLOT( newMainWindow( const KURL & ) ) );

  mActionManager->loadParts();

  initActions();
  readSettings();

  KStatusBar *bar = statusBar();

  bar->insertItem( "", ID_GENERAL, 10 );
  connect( bar, TQ_SIGNAL( pressed( int ) ), TQ_SLOT( statusBarPressed( int ) ) );

  KPIM::ProgressDialog *progressDialog = new KPIM::ProgressDialog( bar, this );
  progressDialog->hide();

  KPIM::StatusbarProgressWidget *progressWidget;
  progressWidget = new KPIM::StatusbarProgressWidget( progressDialog, bar );
  progressWidget->show();

  bar->addWidget( progressWidget, 0, true );

  connect( mActionManager->view(), TQ_SIGNAL( statusMessage( const TQString & ) ),
           TQ_SLOT( showStatusMessage( const TQString & ) ) );

  setStandardToolBarMenuEnabled( true );
  setTitle();

  kdDebug(5850) << "KOrganizer::KOrganizer() done" << endl;
}

void KOrganizer::newMainWindow( const KURL &url )
{
  KOrganizer *korg = new KOrganizer();
  if ( url.isValid() || url.isEmpty() ) {
    korg->init( true );
    if ( korg->openURL( url ) || url.isEmpty() ) {
      korg->show();
    } else {
      delete korg;
    }
  } else {
    korg->init( false );
    korg->show();
  }
}

void KOrganizer::readSettings()
{
  // read settings from the TDEConfig, supplying reasonable
  // defaults where none are to be found

  TDEConfig *config = KOGlobals::self()->config();

  mActionManager->readSettings();

  config->sync();
}


void KOrganizer::writeSettings()
{
  kdDebug(5850) << "KOrganizer::writeSettings" << endl;

  TDEConfig *config = KOGlobals::self()->config();

  mActionManager->writeSettings();
  config->sync();
}


void KOrganizer::initActions()
{

  setInstance( TDEGlobal::instance() );

  setXMLFile( "korganizerui.rc" );
  setStandardToolBarMenuEnabled( true );
  createStandardStatusBarAction();

  KStdAction::keyBindings(guiFactory(), TQ_SLOT(configureShortcuts()), actionCollection());
  KStdAction::configureToolbars(this, TQ_SLOT(configureToolbars() ), actionCollection());
  KStdAction::quit( this, TQ_SLOT( close() ), actionCollection() );
  setAutoSaveSettings();

  createGUI( 0 );
}

bool KOrganizer::queryClose()
{
  kdDebug(5850) << "KOrganizer::queryClose()" << endl;

  bool close = mActionManager->queryClose();

  // Write configuration. I don't know if it really makes sense doing it this
  // way, when having opened multiple calendars in different CalendarViews.
  if ( close ) writeSettings();

  return close;
}

bool KOrganizer::queryExit()
{
  // Don't call writeSettings here, because filename isn't valid anymore. It is
  // now called in queryClose.
//  writeSettings();
  return true;
}

void KOrganizer::statusBarPressed( int /*id*/ )
{
}

void KOrganizer::showStatusMessage( const TQString &message )
{
  statusBar()->message(message,2000);
}

bool KOrganizer::openURL( const KURL &url, bool merge )
{
  return mActionManager->openURL( url, merge );
}

bool KOrganizer::saveURL()
{
  return mActionManager->saveURL();
}

bool KOrganizer::saveAsURL( const KURL & kurl )
{
  return mActionManager->saveAsURL( kurl )  ;
}

KURL KOrganizer::getCurrentURL() const
{
  return mActionManager->url();
}

void KOrganizer::saveProperties( TDEConfig *config )
{
  return mActionManager->saveProperties( config );
}

void KOrganizer::readProperties( TDEConfig *config )
{
  return mActionManager->readProperties( config );
}

KOrg::CalendarViewBase *KOrganizer::view() const
{
  return mActionManager->view();
}

void KOrganizer::setTitle()
{
//  kdDebug(5850) << "KOrganizer::setTitle" << endl;

  TQString title;
  if ( !hasDocument() ) {
    title = i18n("Calendar");
  } else {
    KURL url = mActionManager->url();

    if ( !url.isEmpty() ) {
      if ( url.isLocalFile() ) title = url.fileName();
      else title = url.prettyURL();
    } else {
      title = i18n("New Calendar");
    }

    if ( mCalendarView->isReadOnly() ) {
      title += " [" + i18n("read-only") + "]";
    }
  }

  title += " - <" + mCalendarView->currentFilterName() + "> ";

  setCaption( title, !mCalendarView->isReadOnly() &&
                      mCalendarView->isModified() );
}

bool KOrganizer::isCurrentlyActivePart()
{
  return false;
}

