/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.Deflater;

class RfbProto {
    static final String versionMsg_3_3 = "RFB 003.003\n";
    static final String versionMsg_3_7 = "RFB 003.007\n";
    static final String StandardVendor = "STDV";
    static final String TridiaVncVendor = "TRDV";
    static final String TightVncVendor = "TGHT";
    static final int SecTypeInvalid = 0;
    static final int SecTypeNone = 1;
    static final int SecTypeVncAuth = 2;
    static final int SecTypeTight = 16;
    static final int NoTunneling = 0;
    static final String SigNoTunneling = "NOTUNNEL";
    static final int AuthNone = 1;
    static final int AuthVNC = 2;
    static final int AuthUnixLogin = 129;
    static final String SigAuthNone = "NOAUTH__";
    static final String SigAuthVNC = "VNCAUTH_";
    static final String SigAuthUnixLogin = "ULGNAUTH";
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int SetPixelFormat = 0;
    static final int FixColourMapEntries = 1;
    static final int SetEncodings = 2;
    static final int FramebufferUpdateRequest = 3;
    static final int KeyboardEvent = 4;
    static final int PointerEvent = 5;
    static final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    static final String SigEncodingRaw = "RAW_____";
    static final String SigEncodingCopyRect = "COPYRECT";
    static final String SigEncodingRRE = "RRE_____";
    static final String SigEncodingCoRRE = "CORRE___";
    static final String SigEncodingHextile = "HEXTILE_";
    static final String SigEncodingZlib = "ZLIB____";
    static final String SigEncodingTight = "TIGHT___";
    static final String SigEncodingCompressLevel0 = "COMPRLVL";
    static final String SigEncodingQualityLevel0 = "JPEGQLVL";
    static final String SigEncodingXCursor = "X11CURSR";
    static final String SigEncodingRichCursor = "RCHCURSR";
    static final String SigEncodingPointerPos = "POINTPOS";
    static final String SigEncodingLastRect = "LASTRECT";
    static final String SigEncodingNewFBSize = "NEWFBSIZ";
    static final int MaxNormalEncoding = 7;
    static final int HextileRaw = 1;
    static final int HextileBackgroundSpecified = 2;
    static final int HextileForegroundSpecified = 4;
    static final int HextileAnySubrects = 8;
    static final int HextileSubrectsColoured = 16;
    static final int TightMinToCompress = 12;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    VncViewer viewer;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean recordFromBeginning = true;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    int serverMajor;
    int serverMinor;
    int clientMajor;
    int clientMinor;
    boolean protocolTightVNC;
    CapsContainer tunnelCaps;
    CapsContainer authCaps;
    CapsContainer serverMsgCaps;
    CapsContainer clientMsgCaps;
    CapsContainer encodingCaps;
    private boolean closed;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    RfbProto(String string, int n, VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.host = string;
        this.port = n;
        if (!this.viewer.disableSSL) {
            SSLSocketToMe sSLSocketToMe;
            System.out.println("new SSLSocketToMe");
            try {
                sSLSocketToMe = new SSLSocketToMe(this.host, this.port, vncViewer);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            try {
                this.sock = sSLSocketToMe.connectSock();
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (this.viewer.socketFactory == null) {
            this.sock = new Socket(this.host, this.port);
        } else {
            try {
                Class<?> clazz = Class.forName(this.viewer.socketFactory);
                SocketFactory socketFactory = (SocketFactory)clazz.newInstance();
                this.sock = this.viewer.inAnApplet ? socketFactory.createSocket(this.host, this.port, this.viewer) : socketFactory.createSocket(this.host, this.port, this.viewer.mainArgs);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception.getMessage());
            }
        }
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    synchronized void close() {
        try {
            this.sock.close();
            this.closed = true;
            System.out.println("RFB socket closed");
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    synchronized boolean closed() {
        return this.closed;
    }

    void readVersionMsg() throws Exception {
        byte[] byArray = new byte[12];
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server: " + byArray);
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
        if (this.serverMajor < 3) {
            throw new Exception("RFB server does not support protocol version 3");
        }
    }

    void writeVersionMsg() throws IOException {
        this.clientMajor = 3;
        if (this.serverMajor > 3 || this.serverMinor >= 7) {
            this.clientMinor = 7;
            this.os.write(versionMsg_3_7.getBytes());
        } else {
            this.clientMinor = 3;
            this.os.write(versionMsg_3_3.getBytes());
        }
        this.protocolTightVNC = false;
    }

    int negotiateSecurity() throws Exception {
        return this.clientMinor >= 7 ? this.selectSecurityType() : this.readSecurityType();
    }

    int readSecurityType() throws Exception {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                this.readConnFailedReason();
                return 0;
            }
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new Exception("Unknown security type from RFB server: " + n);
    }

    int selectSecurityType() throws Exception {
        int n = 0;
        int n2 = this.is.readUnsignedByte();
        if (n2 == 0) {
            this.readConnFailedReason();
            return 0;
        }
        byte[] byArray = new byte[n2];
        this.is.readFully(byArray);
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] == 16) {
                this.protocolTightVNC = true;
                this.os.write(16);
                return 16;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (byArray[n4] == 1 || byArray[n4] == 2) {
                n = byArray[n4];
                break;
            }
            ++n4;
        }
        if (n == 0) {
            throw new Exception("Server did not offer supported security type");
        }
        this.os.write(n);
        return n;
    }

    void readConnFailedReason() throws Exception {
        int n = this.is.readInt();
        byte[] byArray = new byte[n];
        this.is.readFully(byArray);
        throw new Exception(new String(byArray));
    }

    void initCapabilities() {
        this.tunnelCaps = new CapsContainer();
        this.authCaps = new CapsContainer();
        this.serverMsgCaps = new CapsContainer();
        this.clientMsgCaps = new CapsContainer();
        this.encodingCaps = new CapsContainer();
        this.authCaps.add(1, StandardVendor, SigAuthNone, "No authentication");
        this.authCaps.add(2, StandardVendor, SigAuthVNC, "Standard VNC password authentication");
        this.authCaps.add(129, TightVncVendor, SigAuthUnixLogin, "Login-style Unix authentication");
        this.encodingCaps.add(1, StandardVendor, SigEncodingCopyRect, "Standard CopyRect encoding");
        this.encodingCaps.add(2, StandardVendor, SigEncodingRRE, "Standard RRE encoding");
        this.encodingCaps.add(4, StandardVendor, SigEncodingCoRRE, "Standard CoRRE encoding");
        this.encodingCaps.add(5, StandardVendor, SigEncodingHextile, "Standard Hextile encoding");
        this.encodingCaps.add(6, TridiaVncVendor, SigEncodingZlib, "Zlib encoding");
        this.encodingCaps.add(7, TightVncVendor, SigEncodingTight, "Tight encoding");
        this.encodingCaps.add(-256, TightVncVendor, SigEncodingCompressLevel0, "Compression level");
        this.encodingCaps.add(-32, TightVncVendor, SigEncodingQualityLevel0, "JPEG quality level");
        this.encodingCaps.add(-240, TightVncVendor, SigEncodingXCursor, "X-style cursor shape update");
        this.encodingCaps.add(-239, TightVncVendor, SigEncodingRichCursor, "Rich-color cursor shape update");
        this.encodingCaps.add(-232, TightVncVendor, SigEncodingPointerPos, "Pointer position update");
        this.encodingCaps.add(-224, TightVncVendor, SigEncodingLastRect, "LastRect protocol extension");
        this.encodingCaps.add(-223, TightVncVendor, SigEncodingNewFBSize, "Framebuffer size change");
    }

    void setupTunneling() throws IOException {
        int n = this.is.readInt();
        if (n != 0) {
            this.readCapabilityList(this.tunnelCaps, n);
            this.writeInt(0);
        }
    }

    int negotiateAuthenticationTight() throws Exception {
        int n = this.is.readInt();
        if (n == 0) {
            return 1;
        }
        this.readCapabilityList(this.authCaps, n);
        int n2 = 0;
        while (n2 < this.authCaps.numEnabled()) {
            int n3 = this.authCaps.getByOrder(n2);
            if (n3 == 1 || n3 == 2 || n3 == 129) {
                this.writeInt(n3);
                return n3;
            }
            ++n2;
        }
        throw new Exception("No suitable authentication scheme found");
    }

    void readCapabilityList(CapsContainer capsContainer, int n) throws IOException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[8];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.is.readInt();
            this.is.readFully(byArray);
            this.is.readFully(byArray2);
            capsContainer.enable(new CapabilityInfo(n3, byArray, byArray2));
            ++n2;
        }
    }

    void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.os.write(byArray);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.viewer.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2);
        if (this.protocolTightVNC) {
            int n2 = this.is.readUnsignedShort();
            int n3 = this.is.readUnsignedShort();
            int n4 = this.is.readUnsignedShort();
            this.is.readUnsignedShort();
            this.readCapabilityList(this.serverMsgCaps, n2);
            this.readCapabilityList(this.clientMsgCaps, n3);
            this.readCapabilityList(this.encodingCaps, n4);
        }
        this.inNormalProtocol = true;
    }

    void startSession(String string) throws IOException {
        this.rec = new SessionRecorder(string);
        this.rec.writeHeader();
        this.rec.write(versionMsg_3_3.getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] byArray = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(byArray);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        if (this.wereZlibUpdates) {
            this.recordFromBeginning = false;
        }
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    int readServerMessageType() throws IOException {
        int n = this.is.readUnsignedByte();
        if (this.rec != null && n == 2) {
            this.rec.writeByte(n);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return n;
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (this.updateRectEncoding == 6 && !this.recordFromBeginning) {
                if (!this.zlibWarningShown) {
                    System.out.println("Warning: Raw encoding will be used instead of Zlib in recorded session.");
                    this.zlibWarningShown = true;
                }
                this.rec.writeIntBE(0);
            } else {
                this.rec.writeIntBE(this.updateRectEncoding);
                if (this.updateRectEncoding == 7 && !this.recordFromBeginning && !this.tightWarningShown) {
                    System.out.println("Warning: Re-compressing Tight-encoded updates for session recording.");
                    this.tightWarningShown = true;
                }
            }
        }
        if (this.updateRectEncoding < 0 || this.updateRectEncoding > 7) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeShortBE(this.copyRectSrcX);
            this.rec.writeShortBE(this.copyRectSrcY);
        }
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2);
    }

    int readCompactLen() throws IOException {
        int[] nArray = new int[3];
        nArray[0] = this.is.readUnsignedByte();
        int n = 1;
        int n2 = nArray[0] & 0x7F;
        if ((nArray[0] & 0x80) != 0) {
            nArray[1] = this.is.readUnsignedByte();
            ++n;
            n2 |= (nArray[1] & 0x7F) << 7;
            if ((nArray[1] & 0x80) != 0) {
                nArray[2] = this.is.readUnsignedByte();
                ++n;
                n2 |= (nArray[2] & 0xFF) << 14;
            }
        }
        if (this.rec != null && this.recordFromBeginning) {
            int n3 = 0;
            while (n3 < n) {
                this.rec.writeByte(nArray[n3]);
                ++n3;
            }
        }
        return n2;
    }

    void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = new byte[]{3, (byte)(bl ? 1 : 0), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = (byte)(bl ? 1 : 0);
        byArray[7] = (byte)(bl2 ? 1 : 0);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        this.os.write(byArray);
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        int n3 = 0;
        while (n3 < n2) {
            byArray[6 + n3 * 6] = (byte)(nArray[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 1] = (byte)(nArray[n3] & 0xFF);
            byArray[6 + n3 * 6 + 2] = (byte)(nArray2[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 3] = (byte)(nArray2[n3] & 0xFF);
            byArray[6 + n3 * 6 + 4] = (byte)(nArray3[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 5] = (byte)(nArray3[n3] & 0xFF);
            ++n3;
        }
        this.os.write(byArray);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        int n2 = 0;
        while (n2 < n) {
            byArray[4 + 4 * n2] = (byte)(nArray[n2] >> 24 & 0xFF);
            byArray[5 + 4 * n2] = (byte)(nArray[n2] >> 16 & 0xFF);
            byArray[6 + 4 * n2] = (byte)(nArray[n2] >> 8 & 0xFF);
            byArray[7 + 4 * n2] = (byte)(nArray[n2] & 0xFF);
            ++n2;
        }
        this.os.write(byArray);
    }

    void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        this.os.write(byArray);
    }

    void writeWheelEvent(MouseWheelEvent mouseWheelEvent) throws IOException {
        int n;
        this.eventBufLen = 0;
        int n2 = mouseWheelEvent.getX();
        int n3 = mouseWheelEvent.getY();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = mouseWheelEvent.getWheelRotation();
        System.out.println("writeWheelEvent: clicks: " + n4);
        if (n4 > 0) {
            n = 16;
        } else if (n4 < 0) {
            n = 8;
        } else {
            return;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)n;
        this.eventBuf[this.eventBufLen++] = (byte)(n2 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n2 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n3 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n3 & 0xFF);
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writePointerEvent(MouseEvent mouseEvent) throws IOException {
        int n = mouseEvent.getModifiers();
        int n2 = 2;
        int n3 = 4;
        if (this.viewer.options.reverseMouseButtons2And3) {
            n2 = 4;
            n3 = 2;
        }
        if (mouseEvent.getID() == 501) {
            if ((n & 8) != 0) {
                this.pointerMask = n2;
                n &= 0xFFFFFFF7;
            } else if ((n & 4) != 0) {
                this.pointerMask = n3;
                n &= 0xFFFFFFFB;
            } else {
                this.pointerMask = 1;
            }
        } else if (mouseEvent.getID() == 502) {
            this.pointerMask = 0;
            if ((n & 8) != 0) {
                n &= 0xFFFFFFF7;
            } else if ((n & 4) != 0) {
                n &= 0xFFFFFFFB;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(n);
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(n4 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n4 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n5 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n5 & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(KeyEvent keyEvent) throws IOException {
        int n;
        boolean bl;
        int n2 = keyEvent.getKeyChar();
        if (n2 == 0) {
            n2 = 65535;
        }
        if (n2 == 65535 && ((bl = keyEvent.getKeyCode()) || bl || bl || bl)) {
            return;
        }
        boolean bl2 = bl = keyEvent.getID() == 401;
        if (this.viewer.debugKeyboard) {
            System.out.println("----------------------------------------");
            System.out.println("evt.getKeyChar:      " + keyEvent.getKeyChar());
            System.out.println("getKeyText:          " + KeyEvent.getKeyText(keyEvent.getKeyCode()));
            System.out.println("evt.getKeyCode:      " + keyEvent.getKeyCode());
            System.out.println("evt.getID:           " + keyEvent.getID());
            System.out.println("evt.getKeyLocation:  " + keyEvent.getKeyLocation());
            System.out.println("evt.isActionKey:     " + keyEvent.isActionKey());
            System.out.println("evt.isControlDown:   " + keyEvent.isControlDown());
            System.out.println("evt.getModifiers:    " + keyEvent.getModifiers());
            System.out.println("getKeyModifiersText: " + KeyEvent.getKeyModifiersText(keyEvent.getModifiers()));
            System.out.println("evt.paramString:     " + keyEvent.paramString());
        }
        if (keyEvent.isActionKey()) {
            switch (keyEvent.getKeyCode()) {
                case 36: {
                    n = 65360;
                    break;
                }
                case 37: {
                    n = 65361;
                    break;
                }
                case 38: {
                    n = 65362;
                    break;
                }
                case 39: {
                    n = 65363;
                    break;
                }
                case 40: {
                    n = 65364;
                    break;
                }
                case 33: {
                    n = 65365;
                    break;
                }
                case 34: {
                    n = 65366;
                    break;
                }
                case 35: {
                    n = 65367;
                    break;
                }
                case 155: {
                    n = 65379;
                    break;
                }
                case 112: {
                    n = 65470;
                    break;
                }
                case 113: {
                    n = 65471;
                    break;
                }
                case 114: {
                    n = 65472;
                    break;
                }
                case 115: {
                    n = 65473;
                    break;
                }
                case 116: {
                    n = 65474;
                    break;
                }
                case 117: {
                    n = 65475;
                    break;
                }
                case 118: {
                    n = 65476;
                    break;
                }
                case 119: {
                    n = 65477;
                    break;
                }
                case 120: {
                    n = 65478;
                    break;
                }
                case 121: {
                    n = 65479;
                    break;
                }
                case 122: {
                    n = 65480;
                    break;
                }
                case 123: {
                    n = 65481;
                    break;
                }
                default: {
                    return;
                }
            }
            if (n == 65474 && this.viewer.mapF5_to_atsign) {
                if (this.viewer.debugKeyboard) {
                    System.out.println("Mapping: F5 -> AT ");
                }
                n = 64;
            }
        } else {
            n = n2;
            if (n < 32) {
                if (keyEvent.isControlDown()) {
                    n += 96;
                } else {
                    switch (n) {
                        case 8: {
                            n = 65288;
                            break;
                        }
                        case 9: {
                            n = 65289;
                            break;
                        }
                        case 10: {
                            n = 65293;
                            break;
                        }
                        case 27: {
                            n = 65307;
                        }
                    }
                }
            } else if (n == 127) {
                n = 65535;
            } else if (!(n <= 255 || n >= 65280 && n <= 65535 || n >= 8352 && n <= 8367)) {
                return;
            }
        }
        if (n == 229 || n == 197 || n == 228 || n == 196 || n == 246 || n == 214 || n == 167 || n == 189 || n == 163) {
            if (bl) {
                this.brokenKeyPressed = true;
            }
            if (!bl && !this.brokenKeyPressed) {
                this.eventBufLen = 0;
                this.writeModifierKeyEvents(keyEvent.getModifiers());
                this.writeKeyEvent(n, true);
                this.os.write(this.eventBuf, 0, this.eventBufLen);
            }
            if (!bl) {
                this.brokenKeyPressed = false;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(keyEvent.getModifiers());
        this.writeKeyEvent(n, bl);
        if (!bl) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int n, boolean bl) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(bl ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    void writeModifierKeyEvents(int n) {
        if (this.viewer.forbid_Ctrl_Alt && (n & 2) != 0 && (n & 8) != 0) {
            int n2 = n;
            n &= 0xFFFFFFF7;
            n &= 0xFFFFFFFD;
            if (this.viewer.debugKeyboard) {
                System.out.println("Ctrl+Alt modifiers: " + n2 + " -> " + n);
            }
        }
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }

    void recordCompressedData(byte[] byArray, int n, int n2) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray, n, n2);
        int n3 = n2 + n2 / 100 + 12;
        byte[] byArray2 = new byte[n3];
        deflater.finish();
        int n4 = deflater.deflate(byArray2);
        this.recordCompactLen(n4);
        this.rec.write(byArray2, 0, n4);
    }

    void recordCompressedData(byte[] byArray) throws IOException {
        this.recordCompressedData(byArray, 0, byArray.length);
    }

    void recordCompactLen(int n) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        byArray[n2++] = (byte)(n & 0x7F);
        if (n > 127) {
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] | 0x80);
            byArray[n2++] = (byte)(n >> 7 & 0x7F);
            if (n > 16383) {
                int n4 = n2 - 1;
                byArray[n4] = (byte)(byArray[n4] | 0x80);
                byArray[n2++] = (byte)(n >> 14 & 0xFF);
            }
        }
        this.rec.write(byArray, 0, n2);
    }
}

