/*
    irccontactmanager.h - Manager of IRC Contacts

    Copyright (c) 2003      by Michel Hermier <michel.hermier@wanadoo.fr>

    Kopete    (c) 2003      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef IRCCONTACTMANAGER_H
#define IRCCONTACTMANAGER_H

#include <tqdict.h>
#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>

class IRCContact;
class IRCAccount;

class IRCServerContact;
class IRCChannelContact;
class IRCUserContact;

namespace KIRC
{
class Engine;
}

namespace Kopete
{
class Contact;
class MetaContact;
}

class KopeteView;

class TQTimer;

/**
 * @author Michel Hermier <michel.hermier@wanadoo.fr>
 *
 * This class is the repository for all the reference of the @ref IRCContact childs.
 * It manage the life cycle of all the @ref IRCServerContact, @ref IRCChannelContact and @ref IRCUserContact objects for the given account.
 */
class IRCContactManager
	: public TQObject
{
	TQ_OBJECT
  

	public:
		IRCContactManager(const TQString &nickName, IRCAccount *account, const char *name=0);

		IRCAccount *account() const { return m_account; }

		IRCServerContact *myServer() const { return m_myServer; }
		IRCUserContact *mySelf() const { return m_mySelf; }

		IRCChannelContact *findChannel(const TQString &channel, Kopete::MetaContact *m=0);
		IRCChannelContact *existChannel(const TQString &channel) const;

		IRCUserContact *findUser(const TQString &nick, Kopete::MetaContact *m=0);
		IRCUserContact *existUser(const TQString &nick) const;

		IRCContact *findContact(const TQString &nick, Kopete::MetaContact *m=0);
		IRCContact *existContact( const TQString &id ) const;

		TQValueList<IRCChannelContact*> findChannelsByMember( IRCUserContact *contact );

		static IRCContact *existContact(const KIRC::Engine *engine, const TQString &nick);

	public slots:
		void unregister(Kopete::Contact *contact);
		void unregisterUser(Kopete::Contact *contact, bool force = false );
		void unregisterChannel(Kopete::Contact *contact, bool force = false );

		void addToNotifyList(const TQString &nick);
		void removeFromNotifyList(const TQString &nick);
		void checkOnlineNotifyList();

	signals:
		void privateMessage(IRCContact *from, IRCContact *to, const TQString &message);

	private slots:
		void slotNewMessage(const TQString &originating, const TQString &channel, const TQString &message);
		void slotNewPrivMessage(const TQString &originating, const TQString &, const TQString &message);
		void slotIsonRecieved();
		void slotIsonTimeout();
		void slotNewNickChange(const TQString &oldnick, const TQString &newnick);
		void slotContactAdded( Kopete::MetaContact *contact );

	private:
		TQDict<IRCChannelContact> m_channels;
		TQDict<IRCUserContact> m_users;

		IRCAccount *m_account;
		IRCServerContact *m_myServer;
		IRCUserContact *m_mySelf;

		TQStringList m_NotifyList;
		TQTimer *m_NotifyTimer;
		bool isonRecieved;
		int socketTimeout;

		static const TQRegExp isChannel;
};

#endif

