/*
 *
 * patience -- main program
 *   Copyright (C) 1995  Paul Olav Tvete
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 *
 * Heavily modified by Mario Weilguni <mweilguni@sime.com>
 *
 */

#ifndef __PWIDGET__H__
#define __PWIDGET__H__

#include <tdemainwindow.h>

class Dealer;
class TDEToggleAction;
class TDESelectAction;
class TDERecentFilesAction;
class TDEAction;
class TQWidgetStack;
class TQLabel;

class pWidget: public TDEMainWindow {
    TQ_OBJECT
  

public:
    pWidget();
    ~pWidget();

public slots:
    void undoMove();
    void changeBackside();
    void animationChanged();
    void newGameType();
    void restart();

    void openGame();
    void openGame(const KURL &url);
    void saveGame();

    void newGame();
    void chooseGame();
    void undoPossible(bool poss);
    void gameWon(bool withhelp);
    void gameLost();
    void changeWallpaper();
    void slotGameInfo(const TQString &);
    void slotUpdateMoves();
    void helpGame();
    void enableAutoDrop();
	 void showStats();

private:
    void setGameCaption();
    void setBackSide(const TQString &deck, const TQString &dir);
    virtual void showEvent(TQShowEvent *e);

private:
    // Members

    Dealer         *dill;	// The current patience

    TDESelectAction  *games;
    TDESelectAction  *wallpapers;
    TDEAction        *backs;
    TDEAction        *undo;
    TDEToggleAction  *animation;
    TDEToggleAction  *dropaction;
    TDEAction        *stats;

    TQPixmap         background;
    TQColor          midcolor;
    TQStringList     wallpaperlist;
    TDERecentFilesAction  *recent;
};

#endif
