/*
 * KAsteroids - Copyright (c) Martin R. Jones 1997
 *
 * Part of the KDE project
 */
#include <config.h>

#include <kstandarddirs.h>
#include <tdecmdlineargs.h>
#include <tdeapplication.h>
#include <tdeaboutdata.h>

#include "version.h"
#include "toplevel.h"

#ifdef KA_ENABLE_SOUND
#include <arts/dispatcher.h>
#endif


static const char description[] =
	I18N_NOOP("TDE Space Game");

int main( int argc, char *argv[] )
{
    TDEAboutData aboutData( "kasteroids", I18N_NOOP("KAsteroids"),
        KASTEROIDS_VERSION, description, TDEAboutData::License_GPL,
        "(c) 1997, Martin R. Jones");
    aboutData.addAuthor("Martin R. Jones",0, "mjones@kde.org");
    TDECmdLineArgs::init( argc, argv, &aboutData );

    TDEApplication app;
    TDEGlobal::locale()->insertCatalogue("libtdegames");
    TDEGlobal::dirs()->addResourceType("sprite", TDEStandardDirs::kde_default("data") + "kasteroids/sprites/");
    TDEGlobal::dirs()->addResourceType("sounds", TDEStandardDirs::kde_default("data") + "kasteroids/sounds/");

#ifdef KA_ENABLE_SOUND
    // setup mcop communication
    Arts::Dispatcher dispatcher;
#endif

    if( app.isRestored() )
        RESTORE(KAstTopLevel)
    else {
        KAstTopLevel *w = new KAstTopLevel;
        app.setMainWidget(w);
        w->show();
    }
    return app.exec();
}

