


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvas_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasImp::TQCanvasImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasImp::~TQCanvasImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasImp *meth = new TQCanvasImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setTiles_5, "setTiles" },
        { Method_setBackgroundPixmap_6, "setBackgroundPixmap" },
        { Method_backgroundPixmap_7, "backgroundPixmap" },
        { Method_setBackgroundColor_8, "setBackgroundColor" },
        { Method_backgroundColor_9, "backgroundColor" },
        { Method_setTile_10, "setTile" },
        { Method_tile_11, "tile" },
        { Method_tilesHorizontally_12, "tilesHorizontally" },
        { Method_tilesVertically_13, "tilesVertically" },
        { Method_tileWidth_14, "tileWidth" },
        { Method_tileHeight_15, "tileHeight" },
        { Method_resize_16, "resize" },
        { Method_width_17, "width" },
        { Method_height_18, "height" },
        { Method_size_19, "size" },
        { Method_rect_20, "rect" },
        { Method_onCanvas_21, "onCanvas" },
        { Method_onCanvas_22, "onCanvas" },
        { Method_validChunk_23, "validChunk" },
        { Method_validChunk_24, "validChunk" },
        { Method_chunkSize_25, "chunkSize" },
        { Method_retune_26, "retune" },
        { Method_sameChunk_27, "sameChunk" },
        { Method_setChangedChunk_28, "setChangedChunk" },
        { Method_setChangedChunkContaining_29, "setChangedChunkContaining" },
        { Method_setAllChanged_30, "setAllChanged" },
        { Method_setChanged_31, "setChanged" },
        { Method_setUnchanged_32, "setUnchanged" },
        { Method_addItemToChunk_33, "addItemToChunk" },
        { Method_removeItemFromChunk_34, "removeItemFromChunk" },
        { Method_addItemToChunkContaining_35, "addItemToChunkContaining" },
        { Method_removeItemFromChunkContaining_36, "removeItemFromChunkContaining" },
        { Method_allItems_37, "allItems" },
        { Method_collisions_38, "collisions" },
        { Method_collisions_39, "collisions" },
        { Method_collisions_40, "collisions" },
        { Method_drawArea_41, "drawArea" },
        { Method_addView_42, "addView" },
        { Method_removeView_43, "removeView" },
        { Method_drawCanvasArea_44, "drawCanvasArea" },
        { Method_drawViewArea_45, "drawViewArea" },
        { Method_addItem_46, "addItem" },
        { Method_addAnimation_47, "addAnimation" },
        { Method_removeItem_48, "removeItem" },
        { Method_removeAnimation_49, "removeAnimation" },
        { Method_setAdvancePeriod_50, "setAdvancePeriod" },
        { Method_setUpdatePeriod_51, "setUpdatePeriod" },
        { Method_setDoubleBuffering_52, "setDoubleBuffering" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasImp *meth = new TQCanvasImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvas pointer from an Object.
 */
TQCanvas *TQCanvasImp::toTQCanvas( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvas *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvas" )
        return 0;

    return op->toNative<TQCanvas>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvas_1:
             return TQCanvas_1( exec, args );
             break;

         case Constructor_QCanvas_2:
             return TQCanvas_2( exec, args );
             break;

         case Constructor_QCanvas_3:
             return TQCanvas_3( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasImp::TQCanvas_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQObject *

    TQObject * arg0 = extractTQObject(exec,args,0);

    const char *arg1 = (args.size() >= 2) ? args[1].toString(exec).ascii() : 0;


    // We should now create an instance of the TQCanvas object

    TQCanvas *ret = new TQCanvas(

          arg0,
          arg1 );

    JSOpaqueProxy *prx = new JSOpaqueProxy( ret, "TQCanvas");
    return KJS::Object( prx );
}

KJS::Object TQCanvasImp::TQCanvas_2( KJS::ExecState *exec, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);


    // We should now create an instance of the TQCanvas object

    TQCanvas *ret = new TQCanvas(

          arg0,
          arg1 );
    JSOpaqueProxy *prx = new JSOpaqueProxy( ret, "TQCanvas");
    return KJS::Object( prx );

}

KJS::Object TQCanvasImp::TQCanvas_3( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter TQPixmap

    TQPixmap arg0 = extractTQPixmap(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

    int arg4 = extractInt(exec, args, 4);


    // We should now create an instance of the TQCanvas object

    TQCanvas *ret = new TQCanvas(

          arg0,
          arg1,
          arg2,
          arg3,
          arg4 );

    JSOpaqueProxy *prx = new JSOpaqueProxy( ret, "TQCanvas");
    return KJS::Object( prx );
}

KJS::Value TQCanvasImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasImp::toTQCanvas( self );

    switch( id ) {

    case Method_setTiles_5:
        return setTiles_5( exec, self, args );
        break;

    case Method_setBackgroundPixmap_6:
        return setBackgroundPixmap_6( exec, self, args );
        break;

    case Method_backgroundPixmap_7:
        return backgroundPixmap_7( exec, self, args );
        break;

    case Method_setBackgroundColor_8:
        return setBackgroundColor_8( exec, self, args );
        break;

    case Method_backgroundColor_9:
        return backgroundColor_9( exec, self, args );
        break;

    case Method_setTile_10:
        return setTile_10( exec, self, args );
        break;

    case Method_tile_11:
        return tile_11( exec, self, args );
        break;

    case Method_tilesHorizontally_12:
        return tilesHorizontally_12( exec, self, args );
        break;

    case Method_tilesVertically_13:
        return tilesVertically_13( exec, self, args );
        break;

    case Method_tileWidth_14:
        return tileWidth_14( exec, self, args );
        break;

    case Method_tileHeight_15:
        return tileHeight_15( exec, self, args );
        break;

    case Method_resize_16:
        return resize_16( exec, self, args );
        break;

    case Method_width_17:
        return width_17( exec, self, args );
        break;

    case Method_height_18:
        return height_18( exec, self, args );
        break;

    case Method_size_19:
        return size_19( exec, self, args );
        break;

    case Method_rect_20:
        return rect_20( exec, self, args );
        break;

    case Method_onCanvas_21:
        return onCanvas_21( exec, self, args );
        break;

    case Method_onCanvas_22:
        return onCanvas_22( exec, self, args );
        break;

    case Method_validChunk_23:
        return validChunk_23( exec, self, args );
        break;

    case Method_validChunk_24:
        return validChunk_24( exec, self, args );
        break;

    case Method_chunkSize_25:
        return chunkSize_25( exec, self, args );
        break;

    case Method_retune_26:
        return retune_26( exec, self, args );
        break;

    case Method_sameChunk_27:
        return sameChunk_27( exec, self, args );
        break;

    case Method_setChangedChunk_28:
        return setChangedChunk_28( exec, self, args );
        break;

    case Method_setChangedChunkContaining_29:
        return setChangedChunkContaining_29( exec, self, args );
        break;

    case Method_setAllChanged_30:
        return setAllChanged_30( exec, self, args );
        break;

    case Method_setChanged_31:
        return setChanged_31( exec, self, args );
        break;

    case Method_setUnchanged_32:
        return setUnchanged_32( exec, self, args );
        break;

    case Method_addItemToChunk_33:
        return addItemToChunk_33( exec, self, args );
        break;

    case Method_removeItemFromChunk_34:
        return removeItemFromChunk_34( exec, self, args );
        break;

    case Method_addItemToChunkContaining_35:
        return addItemToChunkContaining_35( exec, self, args );
        break;

    case Method_removeItemFromChunkContaining_36:
        return removeItemFromChunkContaining_36( exec, self, args );
        break;

    case Method_allItems_37:
        return allItems_37( exec, self, args );
        break;

    case Method_collisions_38:
        return collisions_38( exec, self, args );
        break;

    case Method_collisions_39:
        return collisions_39( exec, self, args );
        break;

    case Method_collisions_40:
        return collisions_40( exec, self, args );
        break;

    case Method_drawArea_41:
        return drawArea_41( exec, self, args );
        break;

    case Method_addView_42:
        return addView_42( exec, self, args );
        break;

    case Method_removeView_43:
        return removeView_43( exec, self, args );
        break;

    case Method_drawCanvasArea_44:
        return drawCanvasArea_44( exec, self, args );
        break;

    case Method_drawViewArea_45:
        return drawViewArea_45( exec, self, args );
        break;

    case Method_addItem_46:
        return addItem_46( exec, self, args );
        break;

    case Method_addAnimation_47:
        return addAnimation_47( exec, self, args );
        break;

    case Method_removeItem_48:
        return removeItem_48( exec, self, args );
        break;

    case Method_removeAnimation_49:
        return removeAnimation_49( exec, self, args );
        break;

    case Method_setAdvancePeriod_50:
        return setAdvancePeriod_50( exec, self, args );
        break;

    case Method_setUpdatePeriod_51:
        return setUpdatePeriod_51( exec, self, args );
        break;

    case Method_setDoubleBuffering_52:
        return setDoubleBuffering_52( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasImp::setTiles_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQPixmap
    return KJS::Value();

    TQPixmap arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

    int arg4 = extractInt(exec, args, 4);

      instance->setTiles(
       arg0,
       arg1,
       arg2,
       arg3,
       arg4 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setBackgroundPixmap_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPixmap arg0 = extractTQPixmap(exec, args, 0);

      instance->setBackgroundPixmap(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::backgroundPixmap_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQPixmap ret;
      ret = instance->backgroundPixmap(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasImp::setBackgroundColor_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQColor arg0 = extractTQColor(exec, args, 0);

      instance->setBackgroundColor(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::backgroundColor_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->backgroundColor(  );
      return KJS::Value(); // Returns 'TQColor'

}

KJS::Value TQCanvasImp::setTile_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->setTile(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::tile_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      int ret;
      ret = instance->tile(
       arg0,
       arg1 );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::tilesHorizontally_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tilesHorizontally(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::tilesVertically_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tilesVertically(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::tileWidth_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tileWidth(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::tileHeight_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tileHeight(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::resize_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->resize(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::width_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->width(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::height_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->height(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::size_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQSize ret;
      ret = instance->size(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasImp::rect_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQRect ret;
      ret = instance->rect(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasImp::onCanvas_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      bool ret;
      ret = instance->onCanvas(
       arg0,
       arg1 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasImp::onCanvas_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPoint arg0 = extractTQPoint(exec, args, 0);

      bool ret;
      ret = instance->onCanvas(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasImp::validChunk_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      bool ret;
      ret = instance->validChunk(
       arg0,
       arg1 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasImp::validChunk_24( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPoint arg0 = extractTQPoint(exec, args, 0);

      bool ret;
      ret = instance->validChunk(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasImp::chunkSize_25( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->chunkSize(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasImp::retune_26( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->retune(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::sameChunk_27( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

      bool ret;
      ret = instance->sameChunk(
       arg0,
       arg1,
       arg2,
       arg3 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasImp::setChangedChunk_28( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setChangedChunk(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setChangedChunkContaining_29( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setChangedChunkContaining(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setAllChanged_30( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->setAllChanged(  );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setChanged_31( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQRect arg0 = extractTQRect(exec, args, 0);

      instance->setChanged(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setUnchanged_32( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQRect arg0 = extractTQRect(exec, args, 0);

      instance->setUnchanged(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::addItemToChunk_33( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->addItemToChunk(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::removeItemFromChunk_34( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->removeItemFromChunk(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::addItemToChunkContaining_35( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->addItemToChunkContaining(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::removeItemFromChunkContaining_36( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->removeItemFromChunkContaining(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::allItems_37( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->allItems(  );
      return KJS::Value(); // Returns 'TQCanvasItemList'

}

KJS::Value TQCanvasImp::collisions_38( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPoint arg0 = extractTQPoint(exec, args, 0);

      instance->collisions(
       arg0 );
      return KJS::Value(); // Returns 'TQCanvasItemList'

}

KJS::Value TQCanvasImp::collisions_39( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQRect arg0 = extractTQRect(exec, args, 0);

      instance->collisions(
       arg0 );
      return KJS::Value(); // Returns 'TQCanvasItemList'

}

KJS::Value TQCanvasImp::collisions_40( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPointArray arg0; // TODO (hack for qcanvas)

    // Unsupported parameter const TQCanvasItem *
    return KJS::Value();

    const TQCanvasItem * arg1; // Dummy

    bool arg2 = extractBool(exec, args, 2);

      instance->collisions(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns 'TQCanvasItemList'

}

KJS::Value TQCanvasImp::drawArea_41( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQRect arg0 = extractTQRect(exec, args, 0);

    // Unsupported parameter TQPainter *
    return KJS::Value();

    TQPainter * arg1; // Dummy

    bool arg2 = extractBool(exec, args, 2);

      instance->drawArea(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::addView_42( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasView *
    return KJS::Value();

    TQCanvasView * arg0; // Dummy

      instance->addView(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::removeView_43( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasView *
    return KJS::Value();

    TQCanvasView * arg0; // Dummy

      instance->removeView(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::drawCanvasArea_44( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQRect arg0 = extractTQRect(exec, args, 0);

    // Unsupported parameter TQPainter *
    return KJS::Value();

    TQPainter * arg1; // Dummy

    bool arg2 = extractBool(exec, args, 2);

      instance->drawCanvasArea(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::drawViewArea_45( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasView *
    return KJS::Value();

    TQCanvasView * arg0; // Dummy

    // Unsupported parameter TQPainter *
    return KJS::Value();

    TQPainter * arg1; // Dummy

    TQRect arg2 = extractTQRect(exec, args, 2);

    bool arg3 = extractBool(exec, args, 3);

      instance->drawViewArea(
       arg0,
       arg1,
       arg2,
       arg3 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::addItem_46( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

      instance->addItem(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::addAnimation_47( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

      instance->addAnimation(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::removeItem_48( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

      instance->removeItem(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::removeAnimation_49( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvasItem *
    return KJS::Value();

    TQCanvasItem * arg0; // Dummy

      instance->removeAnimation(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setAdvancePeriod_50( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->setAdvancePeriod(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setUpdatePeriod_51( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->setUpdatePeriod(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasImp::setDoubleBuffering_52( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setDoubleBuffering(
       arg0 );
      return KJS::Value(); // Returns void

}


} // namespace KJSEmbed
