/***************************************************************************
    begin                : Tue Oct 5 1999
    copyright            : (C) 1999 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#include <tqrect.h>
#include <tqscrollbar.h>
#include <tqheader.h>

#include <kdebug.h>

#include "ksvdraglist.h"
#include "kdltooltip.h"

KDLToolTip::KDLToolTip (KSVDragList *parent, TQToolTipGroup* group)
  : TQToolTip(parent, group),
	mParent (parent)
{
}

KDLToolTip::~KDLToolTip()
{
}

void KDLToolTip::maybeTip (const TQPoint& p)
{
  if (!mParent->displayToolTips())
	return;

  TQString text;
  TQRect rect;

  const TQRect vert = mParent->verticalScrollBar()->geometry();
  const TQRect horiz = mParent->horizontalScrollBar()->geometry();

  if (vert.contains(p))
	{
	  rect = vert;
	  
	  if (!mParent->commonToolTips())
		text = mParent->verticalScrollBarTip();
	  else
		text = mParent->tooltip();
	}
  else if (horiz.contains(p))
	{
	  rect = horiz;
	  if (!mParent->commonToolTips())
		text = mParent->horizontalScrollBarTip();
	  else
		text = mParent->tooltip();
	  
	}
  else
	{ 
	  TQPoint rp = mParent->viewport()->mapFromParent (p);
	  TQListViewItem* i = mParent->itemAt (rp);
	  KSVItem* item = static_cast<KSVItem*> (i);
	  	
	  rect = mParent->header()->geometry();
      if (rect.contains (p))
        {
		  text = mParent->tooltip();
        }
      else if (item)
		{
		  rect = mParent->itemRect (i);
		  rect.moveTopLeft (mParent->viewport()->mapToParent (rect.topLeft()));

		  text = item->tooltip();
		}
	  else
		{
          rect = mParent->rect();

          TQListViewItem* last = mParent->lastItem();          
          if (last)
            rect.setTop (mParent->viewport()->mapToParent (mParent->itemRect(last).bottomRight()).y());
          
		  text = mParent->tooltip();
		}
	}
  
  if (!text.isEmpty())
	tip (rect, text);
}
