/***************************************************************************
                          knetworkinterface.h  -  description
                             -------------------
    begin                : Mon Jan 13 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : jbaptiste@merlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKINTERFACE_H
#define KNETWORKINTERFACE_H

#include <tqstring.h>

/**This class has all the values associated with a network interface.
  *@author Juan Luis Baptiste
  */

class KNetworkInterface {
  public: 
    KNetworkInterface();
    ~KNetworkInterface();

    TQString getBootProto();
    TQString getBroadcast();
    TQString getDeviceName();
    TQString getIpAddress();
    TQString getNetmask();
    TQString getNetwork();
    TQString getOnBoot();
    TQString getGateway();
    void setBootProto(const TQString &bootProto);
    void setBroadcast(const TQString &broadcast);
    void setDeviceName(const TQString &deviceName);
    void setIpAddress(const TQString &ipAddress);
    void setNetmask(const TQString &netmask);
    void setNetwork(const TQString &network);
    void setOnBoot(const TQString &onBoot);
    void setGateway(const TQString &gateway);
    bool isActive();
    void setActive(bool active);
    void setMacAddress(const TQString &addr);
    TQString getMacAddress();
    void setDescription(const TQString &desc);
    TQString getDescription();
    void setType(const TQString &type);
    TQString getType();
    
  private: // Private attributes
    /** Interface name (i.e. eth0, eth1, etc). */
    TQString deviceName;
    /** Boot protocol of the device (static, dhcp). */
    TQString bootProto;
    /** IPv4 address of the interface. */
    TQString ipAddress;
    /** The Netmask. */
    TQString netmask;
    /** The network. */
    TQString network;
    /** The broadcast. */
    TQString broadcast;
    /** thetermines if this device is configured at boot time. */
    TQString onBoot;
    /** default gateway for this device. */
    TQString gateway;
    bool active;
    /** The MAC address. */
    TQString hwAddress;
    /** A little description about the network device. */
    TQString description;
    /** Type of interface (ethernet,wireless,loopback or modem)*/
    TQString type;
};

#endif
