// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include <tqpixmap.h>
#include <tdeglobal.h>
#include <kiconloader.h>

#include "ImageCache.h"

ImageCache::ImageCache()
{
    TDEIconLoader *l = TDEGlobal::iconLoader();
    /* 2002-01-24 FP */
    // _archive       = new TQPixmap(l->iconPath("package", TDEIcon::Toolbar));
    _archive       = new TQPixmap(l->iconPath("application-x-tar", TDEIcon::Small));
    /* 2002-01-24 FP */
    _backup        = new TQPixmap(l->iconPath("kdat_backup", TDEIcon::Toolbar));
    _file          = new TQPixmap(l->iconPath("mime_empty", TDEIcon::Small));
    _folderClosed  = new TQPixmap(l->iconPath("folder_blue", TDEIcon::Small));
    _folderOpen    = new TQPixmap(l->iconPath("folder_blue_open", TDEIcon::Small));
    _restore       = new TQPixmap(l->iconPath("kdat_restore", TDEIcon::Toolbar));
    _selectAll     = new TQPixmap(l->iconPath("kdat_select_all", TDEIcon::Toolbar));
    _selectNone    = new TQPixmap(l->iconPath("kdat_select_none", TDEIcon::Toolbar));
    _selectSome    = new TQPixmap(l->iconPath("kdat_select_some", TDEIcon::Toolbar));
    // 2002-01-28 FP
    // _tape          = new TQPixmap(l->iconPath("kdat_archive", TDEIcon::Toolbar));
    _tape          = new TQPixmap(l->iconPath("kdat", TDEIcon::Small));
    // 2002-01-28 FP
    _tapeMounted   = new TQPixmap(l->iconPath("kdat_mounted", TDEIcon::Toolbar));
    _tapeUnmounted = new TQPixmap(l->iconPath("kdat_unmounted", TDEIcon::Toolbar));
    _verify        = new TQPixmap(l->iconPath("kdat_verify", TDEIcon::Toolbar));
}

ImageCache::~ImageCache()
{
    delete _archive;
    delete _backup;
    delete _file;
    delete _folderClosed;
    delete _folderOpen;
    delete _restore;
    delete _tape;
    delete _tapeMounted;
    delete _tapeUnmounted;
    delete _verify;
}

ImageCache* ImageCache::_instance = 0;

ImageCache* ImageCache::instance()
{
    if ( _instance == 0 ) {
        _instance = new ImageCache();
    }

    return _instance;
}

const TQPixmap* ImageCache::getArchive()
{
    return _archive;
}

const TQPixmap* ImageCache::getBackup()
{
    return _backup;
}

const TQPixmap* ImageCache::getFile()
{
    return _file;
}

const TQPixmap* ImageCache::getFolderClosed()
{
    return _folderClosed;
}

const TQPixmap* ImageCache::getFolderOpen()
{
    return _folderOpen;
}

const TQPixmap* ImageCache::getRestore()
{
    return _restore;
}

const TQPixmap* ImageCache::getSelectAll()
{
    return _selectAll;
}

const TQPixmap* ImageCache::getSelectNone()
{
    return _selectNone;
}

const TQPixmap* ImageCache::getSelectSome()
{
    return _selectSome;
}

const TQPixmap* ImageCache::getTape()
{
    return _tape;
}

const TQPixmap* ImageCache::getTapeMounted()
{
    return _tapeMounted;
}

const TQPixmap* ImageCache::getTapeUnmounted()
{
    return _tapeUnmounted;
}

const TQPixmap* ImageCache::getVerify()
{
    return _verify;
}
