#!/usr/bin/env python

#****************************************************************************
#** $Id: smalltable.py,v 1.1 2002/06/19 07:56:07 phil Exp $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyTQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
import os
from PyTQt.tqt import *
from PyTQt.tqttable import *

TRUE  = 1
FALSE = 0

numRows = 30
numCols = 10

if __name__ == '__main__':
    app = TQApplication(sys.argv)

    table = TQTable(numRows, numCols)

    header = table.horizontalHeader()

    header.setLabel(0, "Tiny", 40)
    header.setLabel(1, "Checkboxes")
    header.setLabel(5, "Combos")
    header.setMovingEnabled(TRUE)

    img = TQImage("trolltech.bmp")
    pix = TQPixmap(img.scaleHeight(table.rowHeight(3)))
    table.setPixmap(3, 2, pix)
    table.setText(3, 2, "A Pixmap")

    comboEntries = TQStringList("one")
    comboEntries.append("two")
    comboEntries.append("three")
    comboEntries.append("four")

    for i in range(numRows):
        item = TQComboTableItem(table, comboEntries, FALSE)
        item.setCurrentItem(i % 4)
        table.setItem(i, 5, item)

    for i in range(numRows):
        table.setItem(i, 1, TQCheckTableItem(table, "Check me"))
    
    table.setCaption("Small table example")
    table.show()
    app.setMainWidget(table)
    app.exec_loop()
