package LCDRange;
use strict;
use TQt;
use TQt::isa qw(TQt::VBox);
use TQt::slots setValue => ['int'];
use TQt::signals valueChanged => ['int'];
use TQt::attributes qw(slider);

sub NEW {
    shift->SUPER::NEW(@_);

    my $lcd = TQt::LCDNumber(2, this, "lcd");

    my $slider = TQt::Slider(&Horizontal, this, "slider");
    slider = $slider;
    slider->setRange(0, 99);
    slider->setValue(0);
    $lcd->connect(slider, TQ_SIGNAL('valueChanged(int)'), TQ_SLOT('display(int)'));
    this->connect(slider, TQ_SIGNAL('valueChanged(int)'), TQ_SIGNAL('valueChanged(int)'));
}

sub value { slider->value }

sub setValue {
    my $value = shift;
    slider->setValue($value);
}

1;
