/***************************************************************************
                           kxetextviewsettings.h
                           --------------------
    begin                : Tue Dec 23 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXETEXTVIEWSETTINGS_H
#define KXETEXTVIEWSETTINGS_H

#include "kxesettings.h"

#include <tqcolor.h>

class KXETextViewSettingsPage;

/**
 * This class represents the group of configuration settings for
 * the text view.
 *
 * @author Olaf Hartig
 */
class KXETextViewSettings : public KXESettings
{
	public:

		KXETextViewSettings( TQObject * pParent = 0, const char * pszName = 0 );

		// The following functions can be used to access this object's settings.
		const TQColor & colorDfltText() const { return m_colorDfltText; }
		const TQColor & colorElemNames() const { return  m_colorElemNames; }
		const TQColor & colorAttrNames() const { return  m_colorAttrNames; }
		const TQColor & colorAttrValues() const { return  m_colorAttrValues; }
		const TQColor & colorSyntaxChars() const { return  m_colorSyntaxChars; }
		const TQColor & colorComments() const { return  m_colorComments; }
		const TQColor & colorErrors() const { return  m_colorErrors; }
    int indentSteps() const { return m_iIndentSteps; }
		bool isWrapOn() const { return m_bWrapOn; }
    
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageName() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageHeader() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageIcon() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQWidget * dialogPage( TQFrame * pParent );

	protected:

		/**
		 * Derived from @ref KXESettings
		 */
		virtual void write( TDEConfig * ) const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void read( const TDEConfig * );
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void setFromPage();
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void updatePage() const;

		// the settings itself
		TQColor m_colorDfltText;
		TQColor m_colorElemNames;
		TQColor m_colorAttrNames;
		TQColor m_colorAttrValues;
		TQColor m_colorSyntaxChars;
		TQColor m_colorComments;
		TQColor m_colorErrors;
    int m_iIndentSteps;
		bool m_bWrapOn;

		/**
		 * the corresponding configuration dialog page
		 * It is created on demand by @ref dialogPage.
		 */
		KXETextViewSettingsPage * m_pDialogPage;

};

#endif
