//=============================================================================
//
//   File : notifiermessage.cpp
//   Created on mar 02 nov 2004 02:41:18 by Iacopo
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2004 Iacopo <iakko@siena.linux.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "notifiermessage.h"
#include "notifierwindow.h"

#include "kvi_iconmanager.h"
#include "kvi_config.h"
#include "kvi_app.h"
#include "kvi_window.h"

#include "kvi_locale.h"
#include "kvi_frame.h"
#include "kvi_mirccntrl.h"
#include "kvi_options.h"

/*
#ifdef COMPILE_ON_WINDOWS
	#include <windows.h>
#endif

#ifdef COMPILE_TDE_SUPPORT
	#include <netwm.h>
#endif
*/

#include <tqapplication.h>
#include <tqpainter.h>
#include <tqimage.h>
#include <tqdesktopwidget.h>
#include <tqtooltip.h>

	#include <tqpopupmenu.h>

extern kvi_time_t g_tNotifierDisabledUntil;

KviNotifierMessage::KviNotifierMessage(KviNotifierWindow * pNotifierWindow, TQPixmap * pImage, const TQString &szText)
{
	m_pText = new TQSimpleRichText(KviMircCntrl::stripControlBytes(szText),pNotifierWindow->defaultFont());
	m_pText->setWidth(pNotifierWindow->textWidth());
	m_pImage = pImage;
	m_bHistoric = false;
}

KviNotifierMessage::~KviNotifierMessage()
{
	delete m_pText;
	if(m_pImage)delete m_pImage;
}

static void increase_transparency(TQImage &buffer,TQImage &srcimg,int iDivisor)
{
	buffer.create(srcimg.width(),srcimg.height(),32);
	buffer.setAlphaBuffer(true);

	for(int y = 0;y < buffer.height();y++)
	{
		TQRgb * dst = (TQRgb *)buffer.scanLine(y);
		TQRgb * end = dst + buffer.width();
		TQRgb * src = (TQRgb *)srcimg.scanLine(y);

		while(dst < end)
		{
			*dst = tqRgba(tqRed(*src),tqGreen(*src),tqBlue(*src),tqAlpha(*src) / iDivisor);
			dst++;
			src++;
		}
	}
}

void KviNotifierMessage::setHistoric()
{
	m_bHistoric = true;
	if(!m_pImage)return;
	if(!m_pImage->hasAlphaChannel())return;
	TQImage tmp;
	TQImage out = m_pImage->convertToImage();
	increase_transparency(tmp,out,2);
	m_pImage->convertFromImage(tmp);
}

