/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//TQt includes
#include <tqlayout.h>
#include <tqvgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include <tqhbox.h>

//KDE includes
#include <tdelocale.h>
#include <tdeactioncollection.h>
#include <kbuttonbox.h>
#include <tdelistbox.h>
#include <tdefiledialog.h>
#include <kurl.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

//Project includes
#include "cupsOptions.h"
#include "ksystemlogConfig.h"

CupsOptions::CupsOptions(TQWidget *parent) :
	TQWidget(parent),
	tabs(this, "tabs"),
	cupsFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Cups log</b>. This list also determines the order in which the files are read.</p></qt>")),
	cupsAccessFileList(this, i18n("<qt><p>These files will be analyzed to display <b>Cups Web Server log</b>. This list also determines the order in which the files are read.</p></qt>"))
	{
	
	TQHBoxLayout *layout = new TQHBoxLayout(this);
	layout->setAutoAdd(true);

	tabs.addTab(&cupsFileList, Globals::cupsMode->pixmap, Globals::cupsMode->name);
	tabs.addTab(&cupsAccessFileList, Globals::cupsAccessMode->pixmap, Globals::cupsAccessMode->name);
	
	connect(&cupsFileList, TQ_SIGNAL(fileListChanged(int)), this, TQ_SLOT(slotFileListChanged(int)));
	connect(&cupsAccessFileList, TQ_SIGNAL(fileListChanged(int)), this, TQ_SLOT(slotFileListChanged(int)));
	
	readConfig();
	

}

CupsOptions::~CupsOptions() {

}

bool CupsOptions::isValid() {
	if (cupsFileList.count()>0 && cupsAccessFileList.count()>0)
		return(true);
	else
		return(false);
}

void CupsOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void CupsOptions::saveConfig() {
	kdDebug() << "Save config from CupsOptions" << endl;
	
	TQStringList list;
	
	int count=cupsFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(cupsFileList.getText(i));
	}
	
	KSystemLogConfig::setCupsPaths(list);

	list.clear();
	
	count=cupsAccessFileList.count();
	
	for (int i=0; i<count; i++) {
		list.push_back(cupsAccessFileList.getText(i));
	}
	
	KSystemLogConfig::setCupsAccessPaths(list);

}

void CupsOptions::readConfig() {
	TQStringList cupsFiles(KSystemLogConfig::cupsPaths());
		
	TQStringList::iterator it;
	for(it=cupsFiles.begin(); it!=cupsFiles.end(); ++it) {
		cupsFileList.insertItem(*it);
	}

	TQStringList cupsAccessFiles(KSystemLogConfig::cupsAccessPaths());
		
	for(it=cupsAccessFiles.begin(); it!=cupsAccessFiles.end(); ++it) {
		cupsAccessFileList.insertItem(*it);
	}
}

#include "cupsOptions.moc"
