/***************************************************************************
                          sq_treeviewitem.cpp  -  description
                             -------------------
    begin                : Feb 22 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqpainter.h>

#include "sq_treeviewitem.h"

SQ_TreeViewItem::SQ_TreeViewItem(KFileTreeViewItem *parentItem, KFileItem *fileItem, KFileTreeBranch *parentBranch)
    : KFileTreeViewItem(parentItem, fileItem, parentBranch),
        m_checked(false), count_files(0), count_dirs(0), use_c1(false), use_c2(false)
{}

SQ_TreeViewItem::SQ_TreeViewItem(KFileTreeView *parent, KFileItem *fileItem, KFileTreeBranch *parentBranch)
    : KFileTreeViewItem(parent, fileItem, parentBranch),
        m_checked(false), count_files(0), count_dirs(0), use_c1(false), use_c2(false)
{}

SQ_TreeViewItem::~SQ_TreeViewItem()
{}

void SQ_TreeViewItem::paintFocus(TQPainter *, const TQColorGroup &, const TQRect &)
{}

void SQ_TreeViewItem::paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment)
{
    TDEListView *klv = static_cast<TDEListView *>(listView());

    // mark item
    if(column)
    {
        int h = height();
        int w = klv->columnWidth(1);
        const int m = 6;
        const int marg = 2;

        p->fillRect(0,0,w,h,cg.base());

        p->setPen(black);
        p->setBrush(cg.base());
        p->drawRect(marg, marg, w-marg*2, h-marg*2);

        if(m_checked)
            p->fillRect((w-m)/2, (h-m)/2, m, m, cg.highlight());
    }
    else // file name and pixmap
    {
        TQColorGroup cc = cg;

        if(m_checked)
        {
            if(klv->viewport()->backgroundMode() == TQt::FixedColor)
                cc.setColor(TQColorGroup::Background, cg.highlight());
            else
                cc.setColor(TQColorGroup::Base, cg.highlight());
        }
        else if(isAlternate())
        {
            if(klv->viewport()->backgroundMode() == TQt::FixedColor)
                cc.setColor(TQColorGroup::Background, klv->alternateBackground());
            else
                cc.setColor(TQColorGroup::Base, klv->alternateBackground());
        }

        TQListViewItem::paintCell(p, cc, column, width, alignment);
    }
}

void SQ_TreeViewItem::setCount(int c1, int c2)
{
    count_files = c1 < 0 ? 0 : c1;
    count_dirs = c2 < 0 ? 0 : c2;

    setText(0, fileItem()->name());
}

void SQ_TreeViewItem::setText(int column, const TQString &text)
{
    TQString s;

    if(use_c1 && use_c2) // files + dirs: show these two values anyway
        s = TQString::fromLatin1(" [%1/%2]").arg(count_dirs).arg(count_files);
    else if(use_c1 && count_files) // files, file count is > 0
        s = TQString::fromLatin1(" [%1]").arg(count_files);
    else if(use_c2 && count_dirs) // dirs, dir count is > 0
        s = TQString::fromLatin1(" [%1]").arg(count_dirs);

    KFileTreeViewItem::setText(column, text + s);
}

