/***************************************************************************
                          commandplugin.h  -  description
                             -------------------
    begin                : Son Jan 5 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef COMMANDPLUGIN_H
#define COMMANDPLUGIN_H

#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

class TQCheckBox;
class KLineEdit;
class TDEListBox;
class KPushButton;
class CommandPlugin : public Plugin  {
    TQ_OBJECT
  
    public:
        const TQString getName() const;
        const TQString getAccelName() const;
        const int type() const;

        bool checkError();
        void drawInterface( TQWidget* w, TQVBoxLayout* l );
        void fillStructure();
        TQString processFile( BatchRenamer*, int, TQString token, int );
        void finished();

        bool alwaysUsed() const { return false; }
        const TQPixmap getIcon() const;
        
    private slots:
        void add();
        void remove();
        void exec();

    private:
        KLineEdit* commandline;
        TQCheckBox* checkNoBlock;
        TDEListBox* list;
        KPushButton* buttonAdd;
        KPushButton* buttonRemove;

        TQString command;
        bool noblock;
};

#endif
