/***************************************************************************
*   Copyright (C) 2003                                                    *
*                                                                         *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   Based on kstartuplogo from Umbrello http://uml.sourceforge.net        *
***************************************************************************/

#include "kstartuplogo.h"

#include <tdeconfig.h>
#include <tdeglobal.h>

#include <tqcursor.h>

TDEStartupLogo::TDEStartupLogo( TQWidget * parent, const char *name ) : TQWidget( parent, name, WStyle_NoBorder | WStyle_Customize | WDestructiveClose ), m_bReadyToHide( false )
{
	TQString dataDir = locate( "data", "krecipes/pics/startlogo.png" );
	TQPixmap pm( dataDir );
	setBackgroundPixmap( pm );

	resize(pm.size());
	TQRect desk = splashScreenDesktopGeometry();
	setGeometry( ( desk.width() / 2 ) - ( width() / 2 ) + desk.left(),
		( desk.height() / 2 ) - ( height() / 2 ) + desk.top(),
		width(), height() );
}

TDEStartupLogo::~TDEStartupLogo()
{}

void TDEStartupLogo::mousePressEvent( TQMouseEvent* )
{
	if ( m_bReadyToHide ) {
		hide();
	}
}

/* This function is based on TDE's TDEGlobalSettings::splashScreenDesktopGeometry(). */

TQRect TDEStartupLogo::splashScreenDesktopGeometry() const
{
	TQDesktopWidget *dw = TQApplication::desktop();
	
	if (dw->isVirtualDesktop()) {
		TDEConfigGroup group(TDEGlobal::config(), "Windows");
		int scr = group.readNumEntry("Unmanaged", -3);
		if (group.readBoolEntry("XineramaEnabled", true) && scr != -2) {
			if (scr == -3)
				scr = dw->screenNumber(TQCursor::pos());
			return dw->screenGeometry(scr);
		}
		else {
			return dw->geometry();
		}
	}
	else {
		return dw->geometry();
	}
}

#include "kstartuplogo.moc"
