/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RECIPEIMPORTDIALOG_H
#define RECIPEIMPORTDIALOG_H

#include <tqvaluelist.h>
#include <tqmap.h>
#include <tqlistview.h>

#include <kdialogbase.h>

#include "datablocks/recipelist.h"

class TDEListView;

class TQListViewItem;

class Recipe;
class CustomCheckListItem;

/**
  * @author Jason Kivlighn
  */
class RecipeImportDialog : public KDialogBase
{
public:
	RecipeImportDialog( const RecipeList &all_recipes, TQWidget *parent = 0 );
	~RecipeImportDialog();

	RecipeList getSelectedRecipes();

protected slots:
	virtual void languageChange();

private:
	void loadListView();

	TDEListView* kListView;

	TQMap<CustomCheckListItem*, RecipeList::const_iterator> *recipe_items;
	const RecipeList list_copy;
};

/** A specialized TQCheckListItem that sets the state of its children to its
  * current state.
  * @author Jason Kivlighn
  */
class CustomCheckListItem : public TQCheckListItem
{
public:
	CustomCheckListItem( TQListView *parent, const TQString &, Type );
	CustomCheckListItem( CustomCheckListItem *parent, const TQString &, Type );
	CustomCheckListItem( TQCheckListItem *parent, TQCheckListItem *after, const TQString &, Type );

protected:
	virtual void stateChange( bool );
	bool locked() const
	{
		return m_locked;
	}
	void setLocked( bool b )
	{
		m_locked = b;
	}

private:
	bool m_locked;
};

#endif //RECIPEIMPORTDIALOG_H
