#ifndef KPROCESSORVIEW_H
#define KPROCESSORVIEW_H


#include <tdetoolbar.h>
#include <knuminput.h>
#include <tqcheckbox.h>
#include <tdelistview.h>

class MyListView : public TDEListView
{
	TQ_OBJECT
  
	public:
		MyListView(TQWidget *parent) ;
		~MyListView() ;

	protected:
//		virtual void mousePressEvent( TQMouseEvent *event ) ;


	public slots:
		void slotContextMenu( TDEListView *, TQListViewItem *, const TQPoint & ) ;

	signals:
		void showPopupMenu() ;
} ;


class TDEProcessorView : public TDEToolBar
{
	TQ_OBJECT
  
	public:
    	TDEProcessorView(TQWidget *parent = 0, const char *name = 0);
    	~TDEProcessorView();
	
		void setRegisterValues( unsigned char *values ) ;
		void getRegisterValues( unsigned char *values ) ;
		
		void setFlags( unsigned char flags ); 
		unsigned char getFlags() ;
	
	public slots:
		void slotItemRenamed( TQListViewItem * item ) ;
		void slotHexMode() ;
		void showPopupMenu() ;

	signals:
		void processorRegsChanged() ;
		void processorFlagsChanged() ;

	private:
		virtual void resizeEvent( TQResizeEvent *event ) ;
	
	protected:
		MyListView	*view ;
		TQListViewItem	* regs[ 16 ] ;
		TQListViewItem	* zeroFlag, * carryFlag, * ieFlag ;
		bool m_bHexMode ;
};

#endif
