/* This file is part of the KDE project
   Copyright (C) 2003 Peter Simonsson <psn@linux.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KIVIODRAGOBJECT_H
#define KIVIODRAGOBJECT_H

#include <tqdragobject.h>
#include <tqptrlist.h>

#include "kivio_stencil.h"
#include <KoRect.h>

class KivioPage;

class KivioDragObject : public TQDragObject
{
  TQ_OBJECT
  
  public:
    KivioDragObject(TQWidget* dragSource = 0, const char* name = 0);

    const char* format(int i) const;
    TQByteArray encodedData(const char* mimetype) const;
    bool canDecode(TQMimeSource*);
    bool decode(TQMimeSource* e, TQPtrList<KivioStencil>& sl, KivioPage* page);
    void setStencilList(TQPtrList<KivioStencil> l);
    void setStencilRect(KoRect r);

  protected:
    TQByteArray kivioEncoded() const;
    TQByteArray imageEncoded(const char* mimetype) const;

  private:
    enum { NumEncodeFormats = 2 };
    TQCString m_encodeMimeList[NumEncodeFormats];
    TQPtrList<KivioStencil> m_stencilList;
    KoRect m_stencilRect;
};

#endif
