/* This file is part of the KDE project
   Copyright (C) 2001, The Karbon Developers
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _VGRADIENTTABWIDGET_H_
#define _VGRADIENTTABWIDGET_H_

#include <tqwidget.h>
#include <tqtabwidget.h>
#include <tqlistbox.h>
#include <koffice_export.h>
#include "vgradient.h"

class KComboBox;
class VGradientWidget;
class TDEListBox;
class KIntNumInput;
class TQPushButton;
class TQGroupBox;
class KarbonResourceServer;


class VGradientListItem : public TQListBoxItem
{
public:
	VGradientListItem( const VGradient& gradient, TQString filename );
	VGradientListItem( const VGradientListItem& );
	~VGradientListItem();

	TQPixmap& pixmap() { return m_pixmap; }
	const VGradient* gradient() const { return m_gradient; }
	TQString filename() { return m_filename; }
	bool canDelete() { return m_delete; }

	virtual int height( const TQListBox* ) const { return 16; }
	virtual int width( const TQListBox* lb ) const;

protected:
	virtual void paint( TQPainter* p );

private:
	VGradient	*m_gradient;
	TQPixmap		m_pixmap;
	TQString		m_filename;
	bool		m_delete;
}; // VGradientListItem

class VGradientPreview : public TQWidget
{
	public:
		VGradientPreview( VGradient& gradient, double& opacity, TQWidget* parent = 0L, const char* name = 0L );
		~VGradientPreview();

		virtual void paintEvent( TQPaintEvent* );
		
	protected:
		VGradient*     m_gradient;
		double*         m_opacity;
}; // VGradientPreview

class KARBONBASE_EXPORT VGradientTabWidget : public TQTabWidget
{
	TQ_OBJECT
  

	public:
		enum VGradientTarget {
			STROKE,
			FILL
		};
	
		VGradientTabWidget( VGradient& gradient, KarbonResourceServer* server, TQWidget* parent = 0L, const char* name = 0L );
		~VGradientTabWidget();

		const VGradient& gradient();
		void setGradient( VGradient& gradient );

		VGradientTarget target();
		void setTarget( VGradientTarget target );

		double opacity() const;
		void setOpacity( double opacity );

	public slots:
		void combosChange( int );
		void addGradientToPredefs();
		void changeToPredef( TQListBoxItem* );
		void predefSelected( TQListBoxItem* );
		void deletePredef();
		void opacityChanged( int );

	protected:
		void setupUI();
		void initUI();
		void setupConnections();
		
	private:
		TQGroupBox				*m_editGroup;
		VGradientWidget			*m_gradientWidget;
		KComboBox				*m_gradientTarget;
		KComboBox				*m_gradientRepeat;
		KComboBox				*m_gradientType;
		VGradientPreview		*m_gradientPreview;
		TDEListBox				*m_predefGradientsView;
		TQPushButton				*m_predefDelete;
		TQPushButton				*m_predefImport;
		TQPushButton				*m_addToPredefs;
		KIntNumInput			*m_opacity;

		VGradient             m_gradient;
			/** The predefined gradients list. */
		KarbonResourceServer* m_resourceServer;
		double                m_gradOpacity;
}; // VGradientTabWidget

#endif /* _VGRADIENTTABWIDGET_H_ */
