/***************************************************************************
                          knutmessage.cpp  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutmessage.h"
#include <tdeglobal.h>
#include <kiconloader.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <tqpixmap.h>
#include <tqtimer.h>


KNutMessage::KNutMessage(const TQString messageText, const typeOfMessage type, const long int timeValidity, TQWidget *parent, const char *name) : KDialogBase(Plain, "Messages",Ok,Ok, parent, name, false, false) {


  setCaption("KNutClient");
  m_messageTimer = 0;
  TDEIconLoader *loader = TDEGlobal::iconLoader();

  switch(type) {
    case infoMess:
       m_ret = loader->loadIcon("messagebox_info", TDEIcon::NoGroup, TDEIcon::SizeMedium, TDEIcon::DefaultState, 0, true);
       break;
    case warningMess:
       m_ret = loader->loadIcon("messagebox_warning", TDEIcon::NoGroup, TDEIcon::SizeMedium, TDEIcon::DefaultState, 0, true);
       break;
    case criticalMess:
       m_ret = loader->loadIcon("messagebox_critical", TDEIcon::NoGroup, TDEIcon::SizeMedium, TDEIcon::DefaultState, 0, true);
       break;
    }

   TQFrame *page = plainPage();

   TQVBoxLayout *setTopLayout =     new TQVBoxLayout( page, 10, spacingHint(), "setTopLayout" );
   TQHBoxLayout *setMessageLayout = new TQHBoxLayout( setTopLayout, spacingHint(), "setMessageLayout" );

   TQLabel* picture = new TQLabel (page);
   TQLabel* text = new TQLabel (messageText,page);
   picture->setPixmap(m_ret);

   setMessageLayout->addWidget(picture);
   setMessageLayout->addWidget(text);

   if (timeValidity > 0 ) {
     m_messageTimer = new TQTimer(this);
     if (timeValidity > maxTime)
       m_messageTimer->start(maxTime*1000);
     else
       m_messageTimer->start(timeValidity*1000);
     connect (m_messageTimer,TQ_SIGNAL(timeout()),this,TQ_SLOT(timeout()));
     disableResize();
    }
  }

KNutMessage::~KNutMessage(){
  }

void KNutMessage::timeout(void) {

  if (m_messageTimer) m_messageTimer->stop();

  emit endMessage();
  }


void KNutMessage::slotOk (void) {

  if (m_messageTimer) m_messageTimer->stop();
  emit endMessage();
  }

void KNutMessage::moveEvent ( TQMoveEvent * e) {

  KDialogBase::moveEvent (e);
  emit messageMoved(x(),y());
}


#include "knutmessage.moc"
