/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef XMLNAMES_H
#define XMLNAMES_H

#include <tqstring.h>
#include <tdemacros.h>

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/
namespace KMF {

class TDE_EXPORT XML {
	private: 
		XML();
		
	public:
		~XML();
		// Document Elements
		static const TQString& GenericDoc_DocumentElement;
		static const TQString& IPTDoc_DocumentElement;
		static const TQString& KMFNetwork_DocumentElement;
		
		// Elements
		static const TQString& Table_Element;
		static const TQString& Chain_Element;
		static const TQString& Rule_Element;
		static const TQString& RuleOption_Element;
		static const TQString& RuleOptionValue_Element;
		static const TQString& Protocol_Element;
		static const TQString& ProtocolUsage_Element;
		static const TQString& ProtocolCategory_Element;
		static const TQString& Logging_Element;
		static const TQString& Target_Element;
		static const TQString& TargetConfig_Element;
		static const TQString& Port_Element;
		static const TQString& Abstract_Element;
		static const TQString& ICMP_Element;
		static const TQString& NAT_Element;
		static const TQString& NetHost_Element;
		static const TQString& NetZone_Element;
		static const TQString& FromIP_Element;
		static const TQString& NetMask_Element;
		static const TQString& Interface_Element;
		static const TQString& OS_Element;
		static const TQString& BackEnd_Element;
		static const TQString& Distribution_Element;
		static const TQString& InitPath_Element;
		static const TQString& IPTPath_Element;
		static const TQString& ModprobePath_Element;
		static const TQString& RcDefaultPath_Element;
		
		
		
		// Attributes
		static const TQString& Uuid_Attribute;
		static const TQString& Name_Attribute;
		static const TQString& Description_Attribute;
		static const TQString& GUIName_Attribute;	
		static const TQString& Protocol_Attribute;
		static const TQString& Address_Attribute;
		static const TQString& ReadOnly_Attribute;
		static const TQString& Type_Attribute;
		static const TQString& TargetOption_Attribute;
		static const TQString& BuiltIn_Attribute;
		static const TQString& DefaultTarget_Attribute;
		static const TQString& Logging_Attribute;
		static const TQString& Target_Attribute;
		static const TQString& Prefix_Attribute;
		static const TQString& Limit_Attribute;
		static const TQString& Burst_Attribute;
		static const TQString& IO_Attribute;
		static const TQString& ProtocolUuid_Attribute;
		static const TQString& Enabled_Attribute;
		static const TQString& CustomRule_Attribute;
		static const TQString& Num_Attribute;
		static const TQString& Version_Attribute;
		static const TQString& MinVersion_Attribute;
		static const TQString& MaxVersion_Attribute;
		static const TQString& RestrictOutgoingConnections_Attribute;
		static const TQString& AllowIncomingConnections_Attribute;
		static const TQString& LogDropped_Attribute;
		static const TQString& LimitLog_Attribute;
		static const TQString& LogPrefix_Attribute;
		static const TQString& AllowPingReply_Attribute;
		static const TQString& LimitPingReply_Attribute;
		static const TQString& UseNat_Attribute;
		static const TQString& UseMasquerade_Attribute;
		static const TQString& NatAddress_Attribute;
		static const TQString& OutgoingInterface_Attribute;
		static const TQString& UseFilter_Attribute;
		static const TQString& Use_Nat_Attribute;
		static const TQString& UseMangle_Attribute;
		static const TQString& UseModules_Attribute;
		static const TQString& UseRpFilter_Attribute;
		static const TQString& UseIPFwd_Attribute;
		static const TQString& UseSynCookies_Attribute;
		static const TQString& UseMartians_Attribute;
		static const TQString& LogIncoming_Attribute;
		static const TQString& LogOutgoing_Attribute;
		static const TQString& LimitRate_Attribute;
		static const TQString& LimitScale_Attribute;
		static const TQString& Interface_Attribute;
		static const TQString& SSHPort_Attribute;
		//Values
		static const TQString& Yes_Value;
		static const TQString& No_Value;
		static const TQString& BoolOn_Value;
		static const TQString& BoolOff_Value;
		static const TQString& Undefined_Value;
		static const TQString& Incoming_Value;
		static const TQString& Outgoing_Value;
		static const TQString& UDP_Value;
		static const TQString& TCP_Value;
		
		static const TQString& IPTablesGUIInterface_Value;
		static const TQString& GenericGUIInterface_Value;
};




class TDE_EXPORT Constants {
	private: 
		Constants();
	public:
		~Constants();
		static const TQString& Localhost_Name;
		static const TQString& Localhost_IP;
		static const TQString& MyNetwork_Name;
		static const TQString& FilterTable_Name;
		static const TQString& NatTable_Name;
		static const TQString& MangleTable_Name;
		
		static const TQString& InputChain_Name;
		static const TQString& OutputChain_Name;
		static const TQString& ForwardChain_Name;
		static const TQString& PreRoutingChain_Name;
		static const TQString& PostRoutingChain_Name;

		static const TQString& StartFirewallJob_Name;
		static const TQString& StopFirewallJob_Name;
		static const TQString& InstallFirewallJob_Name;
		static const TQString& UninstallFirewallJob_Name;
		static const TQString& ShowConfigJob_Name;
		
};		

}
#endif




