/***************************************************************************
*   Copyright (C) 2005 by Christian Hubinger   *
*   e9806056@student.tuwien.ac.at   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/


#include <kuniqueapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <dcopclient.h>
#include "kmfiptinterface.h"
#include "version.h"
static const char description[] =
    I18N_NOOP( "A TDE KPart Application" );

static const char version[] = "0.1";

static TDECmdLineOptions options[] =
    {
        TDECmdLineLastOption
    };

int main ( int argc, char *argv[] ) {
	TDELocale::setMainCatalogue( "tdelibs" );
	TDEAboutData aboutdata( "kmfiptinterface", I18N_NOOP( "TDE" ),
	                      version, description,
	                      TDEAboutData::License_GPL, "(C) 2001, Christian Hubinger" );
	aboutdata.addAuthor( "Christian Hubinger", I18N_NOOP( "Developer" ), "e9806056@student.tuwien.ac.at" );

	TDECmdLineArgs::init( argc, argv, &aboutdata );
	TDECmdLineArgs::addCmdLineOptions( options );
	KUniqueApplication::addCmdLineOptions();
	kdDebug() << "Starting up...!" << endl;
	if ( ! KUniqueApplication::start() ) {
		kdDebug() << "kmfiptinterface is already running!" << endl;
		return ( 0 );
	}

	KUniqueApplication app;
	kdDebug() << "starting kmfiptinterface " << endl;
	// This app is started automatically, no need for session management
	app.dcopClient() ->setAcceptCalls( true );
	kdDebug() << app.dcopClient() ->appId() << endl;
	kdDebug() << "starting kmfiptinterface " << endl;

	app.disableSessionManagement();
	/*KMFIPTInterface *service =*/ new KMFIPTInterface;
	return app.exec();

}
