/* ============================================================
 * File  : dmessagebox.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-02-22
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef DMESSAGEBOX_H
#define DMESSAGEBOX_H

// Digikam Message Box
// If One Message Box is already open, and more messages are posted they will be appended to the open messagebox

#include <tqwidget.h>
#include <tqstring.h>

class TQLabel;
class TQTextEdit;

namespace KIPIKameraKlientPlugin
{

class DMessageBox : public TQWidget {
    TQ_OBJECT
  

public:
    DMessageBox();
    ~DMessageBox();

    void appendMsg(const TQString& msg);
    static void showMsg(const TQString& msg);
    
private:
    static DMessageBox* s_instance;

    int        count_;
    TQLabel    *msgBox_;
    TQTextEdit *extraMsgBox_;
    TQString    mainMsg_;

private slots:
    void slotOkClicked();
};

}  // NameSpace KIPIKameraKlientPlugin

#endif /* DMESSAGEBOX_H */
