/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef BATCHPROCESSIMAGESDIALOG_H
#define BATCHPROCESSIMAGESDIALOG_H

#define OVERWRITE_ASK    0
#define OVERWRITE_RENAME 1
#define OVERWRITE_SKIP   2
#define OVERWRITE_OVER   3

#define NO_PROCESS       0
#define UNDER_PROCESS    1
#define PROCESS_DONE     2
#define STOP_PROCESS     3

// Include files for TQt

#include <tqstring.h>
#include <tqpushbutton.h>
#include <tqguardedptr.h>

// Include files for KDE

#include <tdeio/job.h>
#include <kdialogbase.h>
#include <kdebug.h>
#include <kurl.h>

// Include files for KIPI

#include <libkipi/interface.h>

// Local includes

#include "batchprocessimagesitem.h"
#include "batchprocessimageslist.h"

class TQLabel;
class TQComboBox;
class TQCheckBox;
class TQFileInfo;
class TQPushButton;
class TQListViewItemIterator;
class TQListViewItem;
class TQGroupBox;

class TDEProcess;
class TDEConfig;
class KProgress;
class KURL;
class KURLRequester;
class KFileItem;

namespace KIPIBatchProcessImagesPlugin
{

class BatchProcessImagesDialog : public KDialogBase
{
TQ_OBJECT
  

 public:
   // Don't forget to add the 'm_Type' and 'm_labelType' implementation in the constructor of
   // children dialog class.

   BatchProcessImagesDialog( KURL::List urlList, KIPI::Interface* interface, TQString caption, TQWidget *parent=0 );
   ~BatchProcessImagesDialog();

protected slots:
    void slotProcessStop(void);

private slots:

   // --------------------------------------------------------------------------------------------------------
   // Standards slots

   void closeEvent ( TQCloseEvent *e );
   void slotOk( void );

   void slotProcessStart(void);
   void slotProcessDone(TDEProcess* proc);
   void slotReadStd(TDEProcess* proc, char *buffer, int buflen);

   void slotPreview(void);
   void slotPreviewProcessDone(TDEProcess* proc);
   void slotPreviewReadStd(TDEProcess* proc, char *buffer, int buflen);
   void slotPreviewStop( void );

   void slotListDoubleClicked(TQListViewItem *itemClicked);

   void slotAddDropItems(TQStringList filesPath);

   void slotImageSelected( TQListViewItem * item );
   void slotGotPreview(const KFileItem* , const TQPixmap &pixmap);

   void slotImagesFilesButtonAdd( void );
   void slotImagesFilesButtonRem( void );

   // --------------------------------------------------------------------------------------------------------
   // Standards virtuals slots for re-implementation

   virtual void slotHelp(void){};                             // Called when 'Help' menu option is actived.
   virtual void slotOptionsClicked(void){};                   // Called when 'Options' button is clicked.
   virtual void slotTypeChanged(int){};                       // Called when the current type option is changed.

 protected:

   // --------------------------------------------------------------------------------------------------------
   // Standards widgets in the dialog

   TQLabel                 *m_labelOverWrite;
   TQLabel                 *m_labelType;
   TQLabel                 *m_imageLabel;

   TQComboBox              *m_overWriteMode;
   TQComboBox              *m_Type;

   KURLRequester          *m_destinationURL;

   BatchProcessImagesList *m_listFiles;
   KProgress              *m_progress;

   TQCheckBox              *m_removeOriginal;
   TQCheckBox              *m_smallPreview;

   TQGroupBox              *groupBox1;
   TQGroupBox              *groupBox2;
   TQGroupBox              *groupBox3;
   TQGroupBox              *groupBox4;
   TQGroupBox              *groupBox41;

   TQPushButton            *m_optionsButton;
   TQPushButton            *m_previewButton;
   TQPushButton            *m_addImagesButton;
   TQPushButton            *m_remImagesButton;
   TQPushButton            *m_helpButton;
   
   TDEConfig                *m_config;

   int                     m_convertStatus;
   int                     m_progressStatus;
   int                     m_nbItem;

   TDEProcess               *m_ProcessusProc;
   TDEProcess               *m_PreviewProc;

   TQListViewItemIterator  *m_listFile2Process_iterator;

   TQString                 whatsThis;
   TQString                 m_ImagesFilesSort;
   TQString                 m_newDir;
   TQString                 m_commandLine;
   TQString                 m_tmpFolder;
   TQString                 m_previewOutput;
   KURL::List              m_selectedImageFiles;

   KIPI::Interface        *m_interface;

   // --------------------------------------------------------------------------------------------------------
   // Standards fonctions

   // Fonctions for ImageMAgick call implementations.

   void    processAborted(bool removeFlag=false); // Called when ImageMagick process is stopped by user.
   void    endPreview(void);                      // Called when preview process is done or stopped by user.

   // Called for to parse the files overwriting mode selected by user.

   int     overwriteMode(void);

   // Called for rename the target current image file name if already exist.

   TQString RenameTargetImageFile(TQFileInfo *fi);

   // Extract the arguments from a TDEProcess an merge that in a TQString. Used by makeProcess for to
   // show the command line arguments (debugging).

   TQString extractArguments(TDEProcess *proc);

   // --------------------------------------------------------------------------------------------------------
   // Standards virtuals fonctions for re-implementation.

   // Called when ImageMagick process is started or for another re-implementation without
   // ImageMagick calls (like 'RenameImages' plugin).

   virtual bool startProcess(void);

   // Called when ImageMagick process is done or stopped by user or for another re-implementation without
   // ImageMagick calls (like 'RenameImages' plugin).

   virtual void endProcess(void);

   //  Fonctions for ImageMagick implementation calls only.

   // Called by 'startProcess' fonction at start. You can checking here some things about the current
   // 'item' before the 'startprocess' fonction execution.

    virtual bool prepareStartProcess(BatchProcessImagesItem */*item*/, const TQString& /*albumDest*/) { return true; };

   // Called for to contruct the ImageMagick command line used for to process or preview the image traitements.
   // If 'albumDest' = 0L ==> preview process.

    virtual TQString makeProcess(TDEProcess* /*proc*/, BatchProcessImagesItem */*item*/,
                                const TQString& /*albumDest*/ = TQString(),
                                bool  /*previewMode*/ = false)
           { return TQString(); };

    virtual void processDone(){};

   // Fonctions used for to read and to save the settings in the configuration file.

   virtual void readSettings(void){};
   virtual void saveSettings(void){};

   // Called for add or update the list of images to process in the dialog.

   virtual void listImageFiles(void);

   // Called by 'listImageFiles' for renamed if necessary the target image file name.

   virtual TQString oldFileName2NewFileName(TQString fileName)
           { return (fileName); };
};

}  // NameSpace KIPIBatchProcessImagesPlugin

#endif  // BATCHPROCESSIMAGESDIALOG_H
