/***************************************************************************
    begin                : Die Sep 16 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                : wijnhout@science.uva.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OUTPUTINFO_H
#define OUTPUTINFO_H

#include <tqvaluelist.h>
#include <tqstring.h>

/**Class for output-information of third program (e.g. Latex-Output, C-Compiler output)

@author Thorsten Lck
  *@author Jeroen Wijnhout
  */

using namespace std;

class OutputInfo
{
    public:
        OutputInfo();
        OutputInfo(const TQString & strSrcFile, int nSrcLine, int nOutputLine, const TQString & strError ="", int nErrorID=-1);

	public:
		/** Source file where error occurred. */
		TQString source() const { return m_strSrcFile; }
		/** Source file where error occurred. */
		void setSource(const TQString & src) { m_strSrcFile = src; }

		/** Line number in source file of the current message */
		int sourceLine() const { return m_nSrcLine; }
		/** Line number in source file of the current message */
		void setSourceLine(int line) { m_nSrcLine =  line; }

		/** Error message */
		TQString message() const { return m_strError; }
		/** Error message */
		void setMessage(const TQString & message) { m_strError = message; }

		/** Error code */
		int type() const { return m_nErrorID; }
		/** Error code */
		void setType(int type) { m_nErrorID = type; }

		/** Line number in the output, where error was reported. */
		int outputLine() const { return m_nOutputLine; }
		/** Line number in the output, where error was reported. */
		void setOutputLine(int line) { m_nOutputLine = line; }

        /** Clears all attributes. */
        void Clear();

private:
	TQString m_strSrcFile, m_file;
	int m_nSrcLine;
	TQString m_strError;
	int m_nOutputLine;
	int m_nErrorID;
};

/**Array of OutputInfo

@author Thorsten Lck
*/
typedef TQValueList<OutputInfo> OutputInfoArray;
#endif
