/***************************************************************************
                          kreplacements.h  -  description
                             -------------------
    begin                : Sat Aug 3 2002
    copyright            : (C) 2002-2007 by Joachim Eibl
    email                : joachim.eibl at gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KREPLACEMENTS_H
#define KREPLACEMENTS_H

#include "common.h"

#include <tqobject.h>
#include <tqtabdialog.h>
#include <tqmainwindow.h>
#include <tqaction.h>
#include <tqfiledialog.h>
#include <tqapplication.h>
#include <tqvbox.h>
#include <tqpushbutton.h>
#include <statusbar.h>
#include <tqtoolbar.h>
#include <tqprogressbar.h>
#include <tqpopupmenu.h>
#include <tqstringlist.h>
#include <tqprinter.h>

#include <map>
#include <list>

TQString getTranslationDir();

class TDEMainWindow;

class KURL
{
public:
   KURL(){}
   KURL(const TQString& s){ m_s = s; }
   static KURL fromPathOrURL( const TQString& s ){ return KURL(s); }
   TQString url() const { return m_s; }
   bool isEmpty() const { return m_s.isEmpty(); }
   TQString prettyURL() const { return m_s; }
   bool isLocalFile() const { return true; }
   bool isValid() const { return true; }
   TQString path() const { return m_s; }
   void setPath( const TQString& s ){ m_s=s; }
   TQString fileName() const { return m_s; } // not really needed
   void addPath( const TQString& s ){ m_s += "/" + s; }
private:
   TQString m_s;
};

class KMessageBox
{
public:
   static void error( TQWidget* parent, const TQString& text, const TQString& caption=TQString() );
   static int warningContinueCancel( TQWidget* parent, const TQString& text, const TQString& caption=TQString(),
      const TQString& button1=TQString("Continue") );
   static void sorry(  TQWidget* parent, const TQString& text, const TQString& caption=TQString() );
   static void information(  TQWidget* parent, const TQString& text, const TQString& caption=TQString() );
   static int  warningYesNo( TQWidget* parent, const TQString& text, const TQString& caption,
      const TQString& button1, const TQString& button2 );
   static int warningYesNoCancel(
         TQWidget* parent, const TQString& text, const TQString& caption,
         const TQString& button1, const TQString& button2 );

   enum {Cancel=-1, No=0, Yes=1, Continue=1};
};

#define i18n(x) TQObject::tr(x)
#define I18N_NOOP(x) x
#define RESTORE(x)
#define _UNLOAD(x)

typedef TQPopupMenu TDEPopupMenu;

class KDialogBase : public TQTabDialog
{
   TQ_OBJECT
  
public:
   KDialogBase( int, const TQString& caption, int, int, TQWidget* parent, const char* name,
     bool /*modal*/, bool );
   ~KDialogBase();

   void incInitialSize ( const TQSize& );
   void setHelp(const TQString& helpfilename, const TQString& );
   enum {IconList, Help, Default, Apply, Ok, Cancel };

   int BarIcon(const TQString& iconName, int );

   TQVBox* addVBoxPage( const TQString& name, const TQString& info, int );
   TQFrame* addPage(  const TQString& name, const TQString& info, int );
   int spacingHint();

   virtual void accept();
signals:
   void applyClicked();

protected slots:
    virtual void slotOk( void );
    virtual void slotApply( void );
    virtual void slotHelp( void );
    virtual void slotCancel( void );
    virtual void slotDefault( void );
};

class KFileDialog : public TQFileDialog
{
public:
   static KURL getSaveURL( const TQString &startDir=TQString(),
                           const TQString &filter=TQString(),
                           TQWidget *parent=0, const TQString &caption=TQString());
   static KURL getOpenURL( const TQString &  startDir = TQString(),
                           const TQString &  filter = TQString(),
                           TQWidget *  parent = 0,
                           const TQString &  caption = TQString() );
   static KURL getExistingURL( const TQString &  startDir = TQString(),
                               TQWidget *  parent = 0,
                               const TQString &  caption = TQString() );
   static TQString getSaveFileName (const TQString &startDir=TQString(), 
                                   const TQString &filter=TQString(), 
                                   TQWidget *parent=0, 
                                   const TQString &caption=TQString());
};

typedef TQStatusBar KStatusBar;

class TDEToolBar : public TQToolBar
{
public:
   TDEToolBar(TQMainWindow* parent);

   enum BarPosition {Top, Bottom, Left, Right};
   BarPosition barPos();
   void setBarPos(BarPosition);
private:
   TQMainWindow* m_pMainWindow;
};

class TDEActionCollection
{
public:
   TDEMainWindow* m_pMainWindow;
   TDEActionCollection( TDEMainWindow* p){ m_pMainWindow=p; }
};

class KKeyDialog
{
public:
   static void configure(void*, TQWidget*){}
   static void configureKeys(TDEActionCollection*, const TQString&){}
   static void configure(TDEActionCollection*, const TQString&){}
};

namespace KParts
{
   class ReadWritePart;
}

class TDEMainWindow : public TQMainWindow
{
   TQ_OBJECT
  
private:
   KStatusBar m_statusBar;
   TDEActionCollection m_actionCollection;
protected:
   virtual bool queryClose() = 0;
   virtual bool queryExit() = 0;
public:
   TQPopupMenu* fileMenu;
   TQPopupMenu* editMenu;
   TQPopupMenu* directoryMenu;
   TQPopupMenu* dirCurrentItemMenu;
   TQPopupMenu* dirCurrentSyncItemMenu;
   TQPopupMenu* movementMenu;
   TQPopupMenu* mergeMenu;
   TQPopupMenu* diffMenu;
   TQPopupMenu* windowsMenu;
   TQPopupMenu* settingsMenu;
   TQPopupMenu* helpMenu;

   TDEToolBar*  m_pToolBar;

   TDEMainWindow( TQWidget* parent, const char* name );
   TDEToolBar* toolBar(const TQString& s = TQString());
   TDEActionCollection* actionCollection();
   void createGUI();
   void createGUI(KParts::ReadWritePart*){createGUI();}

   TQPtrList<TDEMainWindow>* memberList;
public slots:
   void slotHelp();
   void slotAbout();
};

class TDEConfig : public ValueMap
{
   TQString m_fileName;
public:
   TDEConfig();
   ~TDEConfig();
   void readConfigFile(const TQString& configFileName);

   void setGroup(const TQString&);
};

class TDEAction : public TQAction
{
   TQ_OBJECT
  
public:
   TDEAction(const TQString& text, const TQIconSet& icon, int accel, TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, const char* name, bool bToggle=false, bool bMenu=true);
   TDEAction(const TQString& text, int accel, TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, const char* name, bool bToggle=false, bool bMenu=true);
   void init(TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, 
        const char* name, bool bToggle, bool bMenu);
   void setStatusText(const TQString&);
   void plug(TQPopupMenu*);
};

class TDEToggleAction : public TDEAction
{
public:
   TDEToggleAction(const TQString& text, const TQIconSet& icon, int accel, TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, const char* name, bool bMenu=true);
   TDEToggleAction(const TQString& text, int accel, TQObject* receiver, const char* slot, TDEActionCollection* actionCollection, const char* name, bool bMenu=true);
   TDEToggleAction(const TQString& text, const TQIconSet& icon, int accel, TDEActionCollection* actionCollection, const char* name, bool bMenu=true);
   void setChecked(bool);
   bool isChecked();
};


class KStdAction
{
public:
   static TDEAction* open( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* save( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* saveAs( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* print( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* quit( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* cut( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* copy( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* paste( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* selectAll( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEToggleAction* showToolbar( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEToggleAction* showStatusbar( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* preferences( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* about( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* aboutTQt( TDEActionCollection* );
   static TDEAction* help( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* find( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* findNext( TQWidget* parent, const char* slot, TDEActionCollection* );
   static TDEAction* keyBindings( TQWidget* parent, const char* slot, TDEActionCollection* );
};

class TDEIcon
{
public:
   enum {SizeMedium,Small};
};

class TDEFontChooser : public TQWidget
{
   TQ_OBJECT
  
   TQFont m_font;
   TQPushButton* m_pSelectFont;
   TQLabel* m_pLabel;
   TQWidget* m_pParent;
public:
   TDEFontChooser( TQWidget* pParent, const TQString& name, bool, const TQStringList&, bool, int );
   TQFont font();
   void setFont( const TQFont&, bool );
private slots:
   void slotSelectFont();
};

class KColorButton : public TQPushButton
{
   TQ_OBJECT
  
   TQColor m_color;
public:
   KColorButton(TQWidget* parent);
   TQColor color();
   void setColor(const TQColor&);
   virtual void paintEvent(TQPaintEvent* e);
public slots:
   void slotClicked();
};

class KPrinter : public TQPrinter
{
public:
   KPrinter();
   enum e_PageSelection {ApplicationSide};
   TQValueList<int> pageList();
   void setCurrentPage(int);
   void setPageSelection(e_PageSelection);
};

class TDEStandardDirs
{
public:
   TQString findResource(const TQString& resource, const TQString& appName);
};   

struct TDECmdLineOptions
{
   const char* name;
   const char* description;
   int def;
};

#define TDECmdLineLastOption {0,0,0}

class TDEAboutData
{
public:
   TDEAboutData( const TQString& name, const TQString& appName, const TQString& version,
      const TQString& description, int licence,
      const TQString& copyright, int w, const TQString& homepage, const TQString& email);
   TDEAboutData( const TQString& name, const TQString& appName, const TQString& version );
   void addAuthor(const char* name=0, const char* task=0, const char* email=0, const char* weblink=0);
   void addCredit(const char* name=0, const char* task=0, const char* email=0, const char* weblink=0);
   enum { License_GPL };
   
   struct AboutDataEntry
   {
      AboutDataEntry(const TQString& name, const TQString& task, const TQString& email, const TQString& weblink)
      : m_name(name), m_task(task), m_email(email), m_weblink(weblink)  
      {}
      TQString m_name;
      TQString m_task;
      TQString m_email;
      TQString m_weblink;
   };
   
   std::list<AboutDataEntry> m_authorList;
   std::list<AboutDataEntry> m_creditList;
};

typedef TQValueList<TQCString> QCStringList;

class TDECmdLineArgs
{
public:
   static TDECmdLineArgs* parsedArgs();
   static void init( int argc, char**argv, TDEAboutData* );
   static void addCmdLineOptions( TDECmdLineOptions* options ); // Add our own options.

   int count();
   TQString arg(int);
   KURL url(int i){ return KURL(arg(i)); }
   void clear();
   TQString getOption(const TQString&);
   QCStringList getOptionList( const TQString& );
   bool isSet(const TQString&);
};

class TDEIconLoader
{
public:
   TQPixmap loadIcon(const TQString& name, int);
};

class TDEApplication : public TQApplication
{
   TDEConfig m_config;
   TDEIconLoader m_iconLoader;
public:
   TDEApplication();
   static TDEApplication* kApplication();
   TDEIconLoader* iconLoader();
   TDEConfig* config();
   bool isRestored();
};

extern TDEApplication* kapp;

class KLibFactory : public TQObject
{
   TQ_OBJECT
  
public:
   TQObject* create(TQObject*,const TQString&,const TQString&);
};

class KLibLoader
{
public:
   static KLibLoader* self();
   KLibFactory* factory(const TQString&);
};

class KEditToolbar : public TQDialog
{
public:
   KEditToolbar( int ){}
};

class TDEGlobal
{
public:
   static TDEConfig* config() { return 0; }
};

namespace TDEIO
{
   enum UDSEntry {};
   typedef TQValueList<UDSEntry> UDSEntryList;
   class Job : public TQObject
   {
   public:
      void kill(bool){}
      bool error() {return false;}
      void showErrorDialog( TQWidget* ) {}
   };
   class SimpleJob : public Job {};
   SimpleJob* mkdir( KURL );
   SimpleJob* rmdir( KURL );
   SimpleJob* file_delete( KURL, bool );
   class FileCopyJob : public Job {};
   FileCopyJob* file_move(  KURL, KURL, int, bool, bool, bool );
   FileCopyJob* file_copy(  KURL, KURL, int, bool, bool, bool );
   class CopyJob : public Job {};
   CopyJob* link( KURL, KURL, bool );
   class ListJob : public Job {};
   ListJob* listRecursive( KURL, bool, bool );
   ListJob* listDir( KURL, bool, bool );
   class StatJob : public Job {
      public: UDSEntry statResult(){ return (UDSEntry)0; }
   };
   StatJob* stat( KURL, bool, int, bool );
   class TransferJob : public Job {};
   TransferJob* get( KURL, bool, bool );
   TransferJob* put( KURL, int, bool, bool, bool );
};

typedef TQProgressBar KProgress;

class TDEInstance : public TQObject
{
public:
   TDEInstance(TDEAboutData*){}
};

namespace KParts
{
   class MainWindow : public TDEMainWindow
   {
   public:
      MainWindow( TQWidget* parent, const char* name ) : TDEMainWindow(parent,name) {}
      void setXMLFile(const TQString&){}
      void setAutoSaveSettings(){}
      void saveMainWindowSettings(TDEConfig*){}
      void applyMainWindowSettings(TDEConfig*){}
      int factory(){return 0;}
   };

   class Part : public TQObject
   {
   public:
      TDEActionCollection* actionCollection();
      TDEApplication* instance();
      void setWidget( TQWidget* w ){ m_pWidget=w; }
      TQWidget* widget(){return m_pWidget;}
      void setXMLFile(const TQString&){}
   private:
      TQWidget* m_pWidget;
   };

   class ReadOnlyPart : public Part
   {
   public:
   ReadOnlyPart(){}
   ReadOnlyPart(TQObject*,const TQCString&){}
   void setInstance( TDEInstance* ){}
   TQString m_file;
   };

   class ReadWritePart : public ReadOnlyPart
   {
   public:
   ReadWritePart(TQObject*,const TQCString&){}
   void setReadWrite(bool){}
   };

   class Factory : public KLibFactory
   {
      TQ_OBJECT
  
   public:
   virtual KParts::Part* createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args )=0;
   };
};
#endif


