/***************************************************************************
                          common.h  -  Things that are needed often
                             -------------------
    begin                : Mon Mar 18 2002
    copyright            : (C) 2002-2007 by Joachim Eibl
    email                : joachim.eibl at gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _COMMON_H
#define _COMMON_H

#include <assert.h>

template< class T >
T min2( T x, T y )
{
   return x<y ? x : y;
}
template< class T >
T max2( T x, T y )
{
   return x>y ? x : y;
}

typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned int UINT32;


template <class T>
T min3( T d1, T d2, T d3 )
{
   if ( d1 < d2  &&  d1 < d3 ) return d1;
   if ( d2 < d3 ) return d2;
   return d3;
}

template <class T>
T max3( T d1, T d2, T d3 )
{

   if ( d1 > d2  &&  d1 > d3 ) return d1;


   if ( d2 > d3 ) return d2;
   return d3;

}

template <class T>
T minMaxLimiter( T d, T minimum, T maximum )
{
   assert(minimum<=maximum);
   if ( d < minimum ) return minimum;
   if ( d > maximum ) return maximum;
   return d;
}

#include <map>
#include <tqstring.h>
class TQFont;
class TQColor;
class TQSize;
class TQPoint;
class TQStringList;
class TQTextStream;

class ValueMap
{
private:
   std::map<TQString,TQString> m_map;
public:
   ValueMap();
   virtual ~ValueMap();

   void save( TQTextStream& ts );
   void load( TQTextStream& ts );
   TQString getAsString();
   // void load( const TQString& s );

   virtual void writeEntry(const TQString&, const TQFont& );
   virtual void writeEntry(const TQString&, const TQColor& );
   virtual void writeEntry(const TQString&, const TQSize& );
   virtual void writeEntry(const TQString&, const TQPoint& );
   virtual void writeEntry(const TQString&, int );
   virtual void writeEntry(const TQString&, bool );
   virtual void writeEntry(const TQString&, const TQStringList&, char separator );
   virtual void writeEntry(const TQString&, const TQString& );
   virtual void writeEntry(const TQString&, const char* );

   virtual TQFont       readFontEntry (const TQString&, TQFont* defaultVal );
   virtual TQColor      readColorEntry(const TQString&, TQColor* defaultVal );
   virtual TQSize       readSizeEntry (const TQString&, TQSize* defaultVal );
   virtual TQPoint      readPointEntry(const TQString&, TQPoint* defaultVal );
   virtual bool        readBoolEntry (const TQString&, bool bDefault );
   virtual int         readNumEntry  (const TQString&, int iDefault );
   virtual TQStringList readListEntry (const TQString&, const TQStringList& defaultVal, char separator );
   virtual TQString     readEntry     (const TQString&, const TQString& );
};

TQStringList safeStringSplit(const TQString& s, char sepChar=',', char metaChar='\\' );
TQString safeStringJoin(const TQStringList& sl, char sepChar=',', char metaChar='\\' );

#endif
