/***************************************************************************
 *   Copyright (C) 2012-2013 by Timothy Pearson                            *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KCMLDAP_H_
#define _KCMLDAP_H_

#include <tdecmodule.h>
#include <tdeaboutdata.h>
#include <kpushbutton.h>
#include <tdelistview.h>
#include <tdefileitem.h>
#include <tdeglobalsettings.h>
#include <tqpushbutton.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>

#include <libtdeldap.h>

#include "ldapconfigbase.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class LDAPConfig: public TDECModule
{
	TQ_OBJECT

	public:
		LDAPConfig( TQWidget *parent=0, const char *name=0, const TQStringList& = TQStringList() );
		~LDAPConfig();
		
		virtual void load();
		virtual void load( bool useDefaults);
		virtual void save();
		virtual void defaults();
		virtual int buttons();
		virtual TQString quickHelp() const;
		virtual const TDEAboutData *aboutData() const { return myAboutData; };

	private slots:
		void processLockouts();
		void bondToNewRealm();
		void reBondToRealm();
		void removeRealm();
		void deactivateRealm();
		void realmProperties();

	private:
		void updateRealmList();

	private:
		TDEAboutData *myAboutData;
		TDEGlobalSettings *kgs;
		LDAPConfigBase *base;
		LDAPRealmConfigList m_realms;
		LDAPClientRealmConfig m_clientRealmConfig;

		TQString hostFQDN;
};

#endif // _KCMLDAP_H_
